/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.MockQueryMetadata;
import org.apache.cayenne.query.QueryMetadata;

class MockQueryMetadataBuilder {
    private ObjEntity objEntity;
    private DbEntity dbEntity;
    private int limit;
    private int offset;
    private boolean suppressDistinct;

    MockQueryMetadataBuilder() {
    }

    MockQueryMetadataBuilder withDbEntity(DbEntity entity) {
        this.dbEntity = entity;
        return this;
    }

    MockQueryMetadataBuilder withObjEntity(ObjEntity entity) {
        this.objEntity = entity;
        return this;
    }

    MockQueryMetadataBuilder withLimitOffset(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    MockQueryMetadataBuilder withSuppressDistinct() {
        this.suppressDistinct = true;
        return this;
    }

    QueryMetadata build() {
        return new MockQueryMetadata(){

            @Override
            public ObjEntity getObjEntity() {
                return MockQueryMetadataBuilder.this.objEntity;
            }

            @Override
            public DbEntity getDbEntity() {
                return MockQueryMetadataBuilder.this.dbEntity;
            }

            @Override
            public int getFetchOffset() {
                return MockQueryMetadataBuilder.this.offset;
            }

            @Override
            public int getFetchLimit() {
                return MockQueryMetadataBuilder.this.limit;
            }

            @Override
            public Map<String, String> getPathSplitAliases() {
                return Collections.emptyMap();
            }

            @Override
            public boolean isSuppressingDistinct() {
                return MockQueryMetadataBuilder.this.suppressDistinct;
            }
        };
    }
}

