/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.translator.select.BaseColumnExtractorTest;
import org.apache.cayenne.access.translator.select.IdColumnExtractor;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class IdColumnExtractorTest
extends BaseColumnExtractorTest {
    @Test
    public void testExtractNoPrefix() {
        DbEntity mockDbEntity = this.createMockDbEntity("mock");
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withMetaData(new MockQueryMetadataBuilder().withDbEntity(mockDbEntity).build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        DataMap dataMap = new DataMap();
        dataMap.addDbEntity(mockDbEntity);
        ObjEntity entity = new ObjEntity();
        entity.setDataMap(dataMap);
        entity.setDbEntity(mockDbEntity);
        IdColumnExtractor extractor = new IdColumnExtractor((TranslatorContext)context, entity);
        extractor.extract();
        Assert.assertEquals((long)1L, (long)context.getResultNodeList().size());
        ResultNodeDescriptor descriptor0 = context.getResultNodeList().get(0);
        Assert.assertNull(descriptor0.getProperty());
        Assert.assertNotNull((Object)descriptor0.getNode());
        Assert.assertThat((Object)descriptor0.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor0.isAggregate());
        Assert.assertTrue((boolean)descriptor0.isInDataRow());
        Assert.assertEquals((Object)"id", (Object)descriptor0.getDataRowKey());
        Assert.assertNotNull((Object)descriptor0.getDbAttribute());
        Assert.assertEquals((long)-5L, (long)descriptor0.getJdbcType());
    }

    @Test
    public void testExtractWithPrefix() {
        DbEntity mockDbEntity = this.createMockDbEntity("mock1");
        DbEntity mock2DbEntity = this.createMockDbEntity("mock2");
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withMetaData(new MockQueryMetadataBuilder().withDbEntity(mockDbEntity).build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        ObjEntity entity = new ObjEntity();
        entity.setDbEntity(mockDbEntity);
        DataMap dataMap = new DataMap();
        dataMap.addDbEntity(mockDbEntity);
        dataMap.addDbEntity(mock2DbEntity);
        mockDbEntity.setDataMap(dataMap);
        entity.setDataMap(dataMap);
        DbRelationship relationship = new DbRelationship();
        relationship.setSourceEntity(mockDbEntity);
        relationship.setTargetEntityName("mock1");
        context.getTableTree().addJoinTable("prefix", relationship, JoinType.INNER);
        IdColumnExtractor extractor = new IdColumnExtractor((TranslatorContext)context, entity);
        extractor.extract("prefix");
        Assert.assertEquals((long)1L, (long)context.getResultNodeList().size());
        ResultNodeDescriptor descriptor0 = context.getResultNodeList().get(0);
        Assert.assertNull(descriptor0.getProperty());
        Assert.assertNotNull((Object)descriptor0.getNode());
        Assert.assertThat((Object)descriptor0.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor0.isAggregate());
        Assert.assertTrue((boolean)descriptor0.isInDataRow());
        Assert.assertEquals((Object)"prefix.id", (Object)descriptor0.getDataRowKey());
        Assert.assertNotNull((Object)descriptor0.getDbAttribute());
        Assert.assertEquals((long)-5L, (long)descriptor0.getJdbcType());
    }
}

