/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Collections;
import java.util.Set;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.translator.select.BaseColumnExtractorTest;
import org.apache.cayenne.access.translator.select.CustomColumnSetExtractor;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CustomColumnSetExtractorTest
extends BaseColumnExtractorTest {
    @Test
    public void testExtractWithoutPrefix() {
        DbEntity mockDbEntity = this.createMockDbEntity("mock");
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withNeedsResultSetMapping(true).withMetaData(new MockQueryMetadataBuilder().withDbEntity(mockDbEntity).build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        DataMap dataMap = new DataMap();
        dataMap.addDbEntity(mockDbEntity);
        ObjEntity entity = new ObjEntity();
        entity.setName("mock");
        entity.setDataMap(dataMap);
        entity.setDbEntity(mockDbEntity);
        ObjAttribute attribute = new ObjAttribute();
        attribute.setName("not_name");
        attribute.setDbAttributePath("name");
        attribute.setType("my.type");
        entity.addAttribute(attribute);
        dataMap.addObjEntity(entity);
        EntityResolver resolver = new EntityResolver();
        resolver.addDataMap(dataMap);
        BaseProperty<String> property0 = PropertyFactory.createBase(ExpressionFactory.dbPathExp("name"), String.class);
        Set<Property<?>> properties = Collections.singleton(property0);
        CustomColumnSetExtractor extractor = new CustomColumnSetExtractor(context, properties);
        extractor.extract();
        Assert.assertEquals((long)1L, (long)context.getResultNodeList().size());
        ResultNodeDescriptor descriptor0 = context.getResultNodeList().get(0);
        Assert.assertSame(property0, descriptor0.getProperty());
        Assert.assertNotNull((Object)descriptor0.getNode());
        Assert.assertThat((Object)descriptor0.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor0.isAggregate());
        Assert.assertTrue((boolean)descriptor0.isInDataRow());
        Assert.assertNotNull((Object)descriptor0.getDbAttribute());
        Assert.assertNull((Object)descriptor0.getDataRowKey());
        Assert.assertEquals((long)-3L, (long)descriptor0.getJdbcType());
        Assert.assertEquals((Object)"java.lang.String", (Object)descriptor0.getJavaType());
    }
}

