/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch.legacy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.access.translator.batch.legacy.UpdateBatchTranslator;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.UpdateBatchQuery;
import org.apache.cayenne.testdo.locking.SimpleLockingTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@Deprecated
@UseServerRuntime(value="cayenne-locking.xml")
public class UpdateBatchTranslatorIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DbAdapter adapter;
    @Inject
    private UnitDbAdapter unitAdapter;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testConstructor() throws Exception {
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        UpdateBatchTranslator builder = new UpdateBatchTranslator((UpdateBatchQuery)Mockito.mock(UpdateBatchQuery.class), adapter, null);
        Assert.assertSame((Object)adapter, (Object)builder.adapter);
    }

    @Test
    public void testCreateSqlString() throws Exception {
        DbEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        List<DbAttribute> idAttributes = Collections.singletonList(entity.getAttribute("LOCKING_TEST_ID"));
        List<DbAttribute> updatedAttributes = Collections.singletonList(entity.getAttribute("DESCRIPTION"));
        UpdateBatchQuery updateQuery = new UpdateBatchQuery(entity, idAttributes, updatedAttributes, Collections.emptySet(), 1);
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        UpdateBatchTranslator builder = new UpdateBatchTranslator(updateQuery, adapter, null);
        String generatedSql = builder.getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertEquals((Object)("UPDATE " + entity.getName() + " SET DESCRIPTION = ? WHERE LOCKING_TEST_ID = ?"), (Object)generatedSql);
    }

    @Test
    public void testCreateSqlStringWithNulls() throws Exception {
        DbEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        List<DbAttribute> idAttributes = Arrays.asList(entity.getAttribute("LOCKING_TEST_ID"), entity.getAttribute("NAME"));
        List<DbAttribute> updatedAttributes = Collections.singletonList(entity.getAttribute("DESCRIPTION"));
        Set<String> nullAttributes = Collections.singleton("NAME");
        UpdateBatchQuery updateQuery = new UpdateBatchQuery(entity, idAttributes, updatedAttributes, nullAttributes, 1);
        DbAdapter adapter = (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
        UpdateBatchTranslator builder = new UpdateBatchTranslator(updateQuery, adapter, null);
        String generatedSql = builder.getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertEquals((Object)("UPDATE " + entity.getName() + " SET DESCRIPTION = ? WHERE LOCKING_TEST_ID = ? AND NAME IS NULL"), (Object)generatedSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithIdentifiersQuote() throws Exception {
        DbEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        try {
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            List<DbAttribute> idAttributes = Collections.singletonList(entity.getAttribute("LOCKING_TEST_ID"));
            List<DbAttribute> updatedAttributes = Collections.singletonList(entity.getAttribute("DESCRIPTION"));
            UpdateBatchQuery updateQuery = new UpdateBatchQuery(entity, idAttributes, updatedAttributes, Collections.emptySet(), 1);
            JdbcAdapter adapter = (JdbcAdapter)this.adapter;
            UpdateBatchTranslator builder = new UpdateBatchTranslator(updateQuery, (DbAdapter)adapter, null);
            String generatedSql = builder.getSql();
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertEquals((Object)("UPDATE " + charStart + entity.getName() + charEnd + " SET " + charStart + "DESCRIPTION" + charEnd + " = ? WHERE " + charStart + "LOCKING_TEST_ID" + charEnd + " = ?"), (Object)generatedSql);
        }
        finally {
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithNullsWithIdentifiersQuote() throws Exception {
        DbEntity entity = this.runtime.getDataDomain().getEntityResolver().getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        try {
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            List<DbAttribute> idAttributes = Arrays.asList(entity.getAttribute("LOCKING_TEST_ID"), entity.getAttribute("NAME"));
            List<DbAttribute> updatedAttributes = Collections.singletonList(entity.getAttribute("DESCRIPTION"));
            Set<String> nullAttributes = Collections.singleton("NAME");
            UpdateBatchQuery updateQuery = new UpdateBatchQuery(entity, idAttributes, updatedAttributes, nullAttributes, 1);
            JdbcAdapter adapter = (JdbcAdapter)this.adapter;
            UpdateBatchTranslator builder = new UpdateBatchTranslator(updateQuery, (DbAdapter)adapter, null);
            String generatedSql = builder.getSql();
            Assert.assertNotNull((Object)generatedSql);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            Assert.assertEquals((Object)("UPDATE " + charStart + entity.getName() + charEnd + " SET " + charStart + "DESCRIPTION" + charEnd + " = ? WHERE " + charStart + "LOCKING_TEST_ID" + charEnd + " = ? AND " + charStart + "NAME" + charEnd + " IS NULL"), (Object)generatedSql);
        }
        finally {
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }
}

