/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.BaseSqlBuilderTest;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.SelectBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.SelectNode;
import org.apache.cayenne.map.DbEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SelectBuilderTest
extends BaseSqlBuilderTest {
    @Test
    public void testSelect() {
        SelectBuilder builder = new SelectBuilder(new NodeBuilder[0]);
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT", node);
    }

    @Test
    public void testSelectColumns() {
        SelectBuilder builder = new SelectBuilder(SQLBuilder.column("a"), SQLBuilder.table("c").column("b"));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT a, c.b", node);
        this.assertQuotedSQL("SELECT `a`, `c`.`b`", node);
    }

    @Test
    public void testSelectFrom() {
        SelectBuilder builder = new SelectBuilder(SQLBuilder.column("a")).from((NodeBuilder)SQLBuilder.table("b"));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT a FROM b", node);
        this.assertQuotedSQL("SELECT `a` FROM `b`", node);
    }

    @Test
    public void testSelectFromDbEntity() {
        DbEntity entity = new DbEntity("b");
        entity.setSchema("d");
        entity.setCatalog("c");
        SelectBuilder builder = new SelectBuilder(SQLBuilder.column("a")).from((NodeBuilder)SQLBuilder.table(entity));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT a FROM c.d.b", node);
        this.assertQuotedSQL("SELECT `a` FROM `c`.`d`.`b`", node);
    }

    @Test
    public void testSelectFromWhere() {
        SelectBuilder builder = new SelectBuilder(SQLBuilder.column("a")).from((NodeBuilder)SQLBuilder.table("b")).where(SQLBuilder.column("a").eq(SQLBuilder.value(123)));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT a FROM b WHERE a = 123", node);
    }

    @Test
    public void testSelectFromWhereNull() {
        SelectBuilder builder = new SelectBuilder(SQLBuilder.column("a")).from((NodeBuilder)SQLBuilder.table("b")).where(SQLBuilder.column("a").eq(SQLBuilder.value(null)));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT a FROM b WHERE a IS NULL", node);
    }

    @Test
    public void testSelectFromWhereComplex() {
        SelectBuilder builder = new SelectBuilder(SQLBuilder.column("a")).from((NodeBuilder)SQLBuilder.table("b")).where(SQLBuilder.column("a").eq(SQLBuilder.value(123)).and(SQLBuilder.column("c").lt(SQLBuilder.column("d"))));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT a FROM b WHERE ( a = 123 ) AND ( c < d )", node);
    }

    @Test
    public void testComplexQuery() {
        Node node = SQLBuilder.select(SQLBuilder.table("a").column("ARTIST_ID").as("a_id"), SQLBuilder.count(SQLBuilder.table("p").column("PAINTING_TITLE")).as("p_count")).distinct().from((NodeBuilder)SQLBuilder.table("ARTIST").as("a")).from((NodeBuilder)SQLBuilder.leftJoin(SQLBuilder.table("PAINTING").as("p")).on(SQLBuilder.table("a").column("ARTIST_ID").eq(SQLBuilder.table("p").column("ARTIST_ID")).and(SQLBuilder.table("p").column("ESTIMATED_PRICE").gt(SQLBuilder.value(10))))).where(SQLBuilder.table("a").column("ARTIST_NAME").eq(SQLBuilder.value("Picasso")).and(SQLBuilder.exists(SQLBuilder.select(SQLBuilder.all()).from((NodeBuilder)SQLBuilder.table("GALLERY").as("g")).where(SQLBuilder.table("g").column("GALLERY_ID").eq(SQLBuilder.table("p").column("GALLERY_ID"))))).and(SQLBuilder.value(1).eq(SQLBuilder.value(1))).or(SQLBuilder.value(false))).groupBy(SQLBuilder.table("a").column("ARTIST_ID")).having(SQLBuilder.not(SQLBuilder.count(SQLBuilder.table("p").column("PAINTING_TITLE")).gt(SQLBuilder.value(3)))).orderBy(SQLBuilder.column("p_count").desc(), SQLBuilder.column("a_id").asc()).build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SelectNode.class));
        this.assertSQL("SELECT DISTINCT a.ARTIST_ID a_id, COUNT( p.PAINTING_TITLE ) AS p_count FROM ARTIST a LEFT JOIN PAINTING p ON ( a.ARTIST_ID = p.ARTIST_ID ) AND ( p.ESTIMATED_PRICE > 10 ) WHERE ( ( ( a.ARTIST_NAME = 'Picasso' ) AND EXISTS (SELECT * FROM GALLERY g WHERE g.GALLERY_ID = p.GALLERY_ID) ) AND ( 1 = 1 ) ) OR false GROUP BY a.ARTIST_ID HAVING NOT ( COUNT( p.PAINTING_TITLE ) > 3 ) ORDER BY p_count DESC, a_id", node);
    }
}

