/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.BaseSqlBuilderTest;
import org.apache.cayenne.access.sqlbuilder.DeleteBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.DeleteNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.map.DbEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DeleteBuilderTest
extends BaseSqlBuilderTest {
    @Test
    public void testDelete() {
        DeleteBuilder builder = new DeleteBuilder("test");
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(DeleteNode.class));
        this.assertSQL("DELETE FROM test", node);
    }

    @Test
    public void testDeleteWithQualifier() {
        DeleteBuilder builder = new DeleteBuilder("test");
        Node node = builder.where(SQLBuilder.column("col1").eq(SQLBuilder.value(1)).and(SQLBuilder.column("col2").eq(SQLBuilder.value("test"))).and(SQLBuilder.column("col3").eq(SQLBuilder.value(null)))).build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(DeleteNode.class));
        this.assertSQL("DELETE FROM test WHERE ( ( col1 = 1 ) AND ( col2 = 'test' ) ) AND ( col3 IS NULL )", node);
    }

    @Test
    public void testDeleteDbEntityCatalog() {
        DbEntity entity = new DbEntity("test");
        entity.setCatalog("catalog");
        DeleteBuilder builder = new DeleteBuilder(entity);
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(DeleteNode.class));
        this.assertSQL("DELETE FROM catalog.test", node);
        this.assertQuotedSQL("DELETE FROM `catalog`.`test`", node);
    }

    @Test
    public void testDeleteDbEntityCatalogAndSchema() {
        DbEntity entity = new DbEntity("test");
        entity.setSchema("schema");
        entity.setCatalog("catalog");
        DeleteBuilder builder = new DeleteBuilder(entity);
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(DeleteNode.class));
        this.assertSQL("DELETE FROM catalog.schema.test", node);
        this.assertQuotedSQL("DELETE FROM `catalog`.`schema`.`test`", node);
    }
}

