/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.Qualifier;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class QualifierTest {
    @Test
    public void testScalarObjectIdQualifier() {
        ObjectId id = ObjectId.of("test", "id", 123);
        Persistent persistent = this.mockObject(id);
        DbRowOp row = this.mockRow(persistent);
        Qualifier qualifier = new Qualifier(row);
        Map<String, Object> qualifierSnapshot = qualifier.getSnapshot();
        Assert.assertEquals(Collections.singletonMap("id", 123), qualifierSnapshot);
        Assert.assertFalse((boolean)qualifier.isUsingOptimisticLocking());
        qualifierSnapshot = qualifier.getSnapshot();
        Assert.assertEquals(Collections.singletonMap("id", 123), qualifierSnapshot);
    }

    @Test
    public void testMapObjectIdQualifier() {
        HashMap<String, Integer> idMap = new HashMap<String, Integer>();
        idMap.put("id1", 123);
        idMap.put("id2", 321);
        ObjectId id = ObjectId.of("test", idMap);
        Persistent persistent = this.mockObject(id);
        DbRowOp row = this.mockRow(persistent);
        Qualifier qualifier = new Qualifier(row);
        Map<String, Object> qualifierSnapshot = qualifier.getSnapshot();
        Assert.assertEquals(idMap, qualifierSnapshot);
        qualifierSnapshot = qualifier.getSnapshot();
        Assert.assertEquals(idMap, qualifierSnapshot);
    }

    @Test
    public void testAdditionalQualifier() {
        ObjectId id = ObjectId.of("test", "id", 123);
        Persistent persistent = this.mockObject(id);
        DbRowOp row = this.mockRow(persistent);
        Qualifier qualifier = new Qualifier(row);
        qualifier.addAdditionalQualifier(new DbAttribute("attr"), 42, true);
        Map<String, Object> qualifierSnapshot = qualifier.getSnapshot();
        HashMap<String, Integer> expectedSnapshot = new HashMap<String, Integer>();
        expectedSnapshot.put("id", 123);
        expectedSnapshot.put("attr", 42);
        Assert.assertEquals(expectedSnapshot, qualifierSnapshot);
        Assert.assertTrue((boolean)qualifier.isUsingOptimisticLocking());
        qualifierSnapshot = qualifier.getSnapshot();
        Assert.assertEquals(expectedSnapshot, qualifierSnapshot);
    }

    @Test
    public void testOptimisticQualifier() {
        ObjectId id = ObjectId.of("test", "id", 123);
        Persistent persistent = this.mockObject(id);
        DbRowOp row = this.mockRow(persistent);
        Qualifier qualifier = new Qualifier(row);
        qualifier.addAdditionalQualifier(new DbAttribute("attr"), 42, true);
        Map<String, Object> qualifierSnapshot = qualifier.getSnapshot();
        HashMap<String, Integer> expectedSnapshot = new HashMap<String, Integer>();
        expectedSnapshot.put("id", 123);
        expectedSnapshot.put("attr", 42);
        Assert.assertEquals(expectedSnapshot, qualifierSnapshot);
        Assert.assertTrue((boolean)qualifier.isUsingOptimisticLocking());
        qualifierSnapshot = qualifier.getSnapshot();
        Assert.assertEquals(expectedSnapshot, qualifierSnapshot);
    }

    @Test
    public void testSameBatch() {
        ObjectId id1 = ObjectId.of("test", "id", 123);
        Persistent persistent1 = this.mockObject(id1);
        DbRowOp row1 = this.mockRow(persistent1);
        Qualifier qualifier1 = new Qualifier(row1);
        ObjectId id2 = ObjectId.of("test", "id", 321);
        Persistent persistent2 = this.mockObject(id2);
        DbRowOp row2 = this.mockRow(persistent2);
        Qualifier qualifier2 = new Qualifier(row2);
        Assert.assertTrue((boolean)qualifier1.isSameBatch(qualifier2));
        ObjectId id3 = ObjectId.of("test", "id", 321);
        Persistent persistent3 = this.mockObject(id3);
        DbRowOp row3 = this.mockRow(persistent3);
        Qualifier qualifier3 = new Qualifier(row3);
        qualifier3.addAdditionalQualifier(new DbAttribute("attr"), 42);
        Assert.assertFalse((boolean)qualifier1.isSameBatch(qualifier3));
    }

    private DbRowOp mockRow(Persistent persistent) {
        DbRowOp row = (DbRowOp)Mockito.mock(DbRowOp.class);
        ObjectId objectId = persistent.getObjectId();
        Mockito.when((Object)row.getChangeId()).thenReturn((Object)objectId);
        Mockito.when((Object)row.getObject()).thenReturn((Object)persistent);
        Mockito.when((Object)row.getEntity()).thenReturn((Object)this.mockEntity());
        return row;
    }

    private Persistent mockObject(ObjectId id) {
        Persistent persistent = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)persistent.getObjectId()).thenReturn((Object)id);
        Mockito.when((Object)persistent.getPersistenceState()).thenReturn((Object)4);
        return persistent;
    }

    private DbEntity mockEntity() {
        DbAttribute attribute1 = new DbAttribute("id");
        attribute1.setPrimaryKey(true);
        DbAttribute attribute2 = new DbAttribute("attr");
        DbEntity testEntity = new DbEntity("TEST");
        testEntity.addAttribute(attribute1);
        testEntity.addAttribute(attribute2);
        return testEntity;
    }
}

