/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpMerger;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DbRowOpMergerTest {
    @Test
    public void testMergeUpdateDelete() {
        ObjectId id = ObjectId.of("test");
        UpdateDbRowOp row1 = new UpdateDbRowOp(this.mockObject(id), this.mockEntity(), id);
        DeleteDbRowOp row2 = new DeleteDbRowOp(this.mockObject(id), this.mockEntity(), id);
        DbRowOpMerger merger = new DbRowOpMerger();
        DbRowOp row = merger.apply(row1, row2);
        Assert.assertSame((Object)row2, (Object)row);
        merger = new DbRowOpMerger();
        row = merger.apply(row2, row1);
        Assert.assertSame((Object)row2, (Object)row);
    }

    @Test
    public void testMergeInsertDelete() {
        ObjectId id = ObjectId.of("test");
        InsertDbRowOp row1 = new InsertDbRowOp(this.mockObject(id), this.mockEntity(), id);
        DeleteDbRowOp row2 = new DeleteDbRowOp(this.mockObject(id), this.mockEntity(), id);
        DbRowOpMerger merger = new DbRowOpMerger();
        DbRowOp row = merger.apply(row1, row2);
        Assert.assertSame((Object)row2, (Object)row);
    }

    @Test
    public void testMergeUpdateInsert() {
        ObjectId id = ObjectId.of("test");
        UpdateDbRowOp row1 = new UpdateDbRowOp(this.mockObject(id), this.mockEntity(), id);
        InsertDbRowOp row2 = new InsertDbRowOp(this.mockObject(id), this.mockEntity(), id);
        DbRowOpMerger merger = new DbRowOpMerger();
        DbRowOp row = merger.apply(row1, row2);
        Assert.assertSame((Object)row2, (Object)row);
        merger = new DbRowOpMerger();
        row = merger.apply(row2, row1);
        Assert.assertSame((Object)row1, (Object)row);
    }

    @Test
    public void testMergeInsertInsert() {
        ObjectId id = ObjectId.of("test");
        DbAttribute attr1 = new DbAttribute("attr1");
        DbAttribute attr2 = new DbAttribute("attr2");
        InsertDbRowOp row1 = new InsertDbRowOp(this.mockObject(id), this.mockEntity(), id);
        row1.getValues().addValue(attr1, 1, false);
        InsertDbRowOp row2 = new InsertDbRowOp(this.mockObject(id), this.mockEntity(), id);
        row2.getValues().addValue(attr2, 2, false);
        DbRowOpMerger merger = new DbRowOpMerger();
        DbRowOp row = merger.apply(row1, row2);
        Assert.assertSame((Object)row2, (Object)row);
        Map<String, Object> snapshot = ((InsertDbRowOp)row).getValues().getSnapshot();
        Assert.assertEquals((long)2L, (long)snapshot.size());
        Assert.assertEquals((Object)1, (Object)snapshot.get("attr1"));
        Assert.assertEquals((Object)2, (Object)snapshot.get("attr2"));
        merger = new DbRowOpMerger();
        row = merger.apply(row2, row1);
        Assert.assertSame((Object)row1, (Object)row);
        snapshot = ((InsertDbRowOp)row).getValues().getSnapshot();
        Assert.assertEquals((long)2L, (long)snapshot.size());
        Assert.assertEquals((Object)1, (Object)snapshot.get("attr1"));
        Assert.assertEquals((Object)2, (Object)snapshot.get("attr2"));
    }

    @Test
    public void testMergeUpdateUpdate() {
        ObjectId id = ObjectId.of("test");
        DbAttribute attr1 = new DbAttribute("attr1");
        DbAttribute attr2 = new DbAttribute("attr2");
        UpdateDbRowOp row1 = new UpdateDbRowOp(this.mockObject(id), this.mockEntity(), id);
        row1.getValues().addValue(attr1, 1, false);
        UpdateDbRowOp row2 = new UpdateDbRowOp(this.mockObject(id), this.mockEntity(), id);
        row2.getValues().addValue(attr2, 2, false);
        DbRowOpMerger merger = new DbRowOpMerger();
        DbRowOp row = merger.apply(row1, row2);
        Assert.assertSame((Object)row2, (Object)row);
        Map<String, Object> snapshot = ((UpdateDbRowOp)row).getValues().getSnapshot();
        Assert.assertEquals((long)2L, (long)snapshot.size());
        Assert.assertEquals((Object)1, (Object)snapshot.get("attr1"));
        Assert.assertEquals((Object)2, (Object)snapshot.get("attr2"));
        merger = new DbRowOpMerger();
        row = merger.apply(row2, row1);
        Assert.assertSame((Object)row1, (Object)row);
        snapshot = ((UpdateDbRowOp)row).getValues().getSnapshot();
        Assert.assertEquals((long)2L, (long)snapshot.size());
        Assert.assertEquals((Object)1, (Object)snapshot.get("attr1"));
        Assert.assertEquals((Object)2, (Object)snapshot.get("attr2"));
    }

    private Persistent mockObject(ObjectId id) {
        Persistent persistent = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)persistent.getObjectId()).thenReturn((Object)id);
        Mockito.when((Object)persistent.getPersistenceState()).thenReturn((Object)4);
        return persistent;
    }

    private DbEntity mockEntity() {
        DbAttribute attribute1 = new DbAttribute("id");
        attribute1.setPrimaryKey(true);
        DbAttribute attribute2 = new DbAttribute("attr");
        DbEntity testEntity = new DbEntity("TEST");
        testEntity.addAttribute(attribute1);
        testEntity.addAttribute(attribute2);
        return testEntity;
    }
}

