/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.flush.operation.BaseDbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpSorter;
import org.apache.cayenne.access.flush.operation.DefaultDbRowOpSorter;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultDbRowOpSorterTest {
    private EntitySorter entitySorter;
    private DbRowOpSorter sorter;

    @Before
    public void createSorter() {
        this.entitySorter = (EntitySorter)Mockito.mock(EntitySorter.class);
        EntityResolver entityResolver = (EntityResolver)Mockito.mock(EntityResolver.class);
        Mockito.when(this.entitySorter.getDbEntityComparator()).thenReturn(Comparator.comparing(Entity::getName));
        Mockito.when((Object)this.entitySorter.isReflexive((DbEntity)Mockito.argThat(ent -> ent.getName().equals("reflexive")))).thenReturn((Object)true);
        DataDomain dataDomain = (DataDomain)Mockito.mock(DataDomain.class);
        Mockito.when((Object)dataDomain.getEntitySorter()).thenReturn((Object)this.entitySorter);
        Mockito.when((Object)dataDomain.getEntityResolver()).thenReturn((Object)entityResolver);
        this.sorter = new DefaultDbRowOpSorter((Provider<DataDomain>)((Provider)() -> dataDomain));
    }

    @Test
    public void sortEmptyList() {
        ArrayList<DbRowOp> rows = new ArrayList<DbRowOp>();
        List<DbRowOp> sorted = this.sorter.sort(rows);
        Assert.assertTrue((boolean)sorted.isEmpty());
    }

    @Test
    public void sortByOpType() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 2);
        ObjectId id3 = ObjectId.of("test", "id", 3);
        ObjectId id4 = ObjectId.of("test", "id", 4);
        ObjectId id5 = ObjectId.of("test", "id", 5);
        ObjectId id6 = ObjectId.of("test", "id", 6);
        DbEntity test = this.mockEntity("test");
        InsertDbRowOp op1 = new InsertDbRowOp(this.mockObject(id1), test, id1);
        UpdateDbRowOp op2 = new UpdateDbRowOp(this.mockObject(id2), test, id2);
        DeleteDbRowOp op3 = new DeleteDbRowOp(this.mockObject(id3), test, id3);
        InsertDbRowOp op4 = new InsertDbRowOp(this.mockObject(id4), test, id4);
        UpdateDbRowOp op5 = new UpdateDbRowOp(this.mockObject(id5), test, id5);
        DeleteDbRowOp op6 = new DeleteDbRowOp(this.mockObject(id6), test, id6);
        List<DbRowOp> rows = Arrays.asList(op1, op2, op3, op4, op5, op6);
        List<DbRowOp> expected = Arrays.asList(op1, op4, op2, op5, op3, op6);
        List<DbRowOp> sorted = this.sorter.sort(rows);
        Assert.assertEquals(expected, sorted);
    }

    @Test
    public void sortByOpEntity() {
        ObjectId id1 = ObjectId.of("test4", "id", 1);
        ObjectId id2 = ObjectId.of("test2", "id", 2);
        ObjectId id3 = ObjectId.of("test3", "id", 3);
        ObjectId id4 = ObjectId.of("test1", "id", 4);
        InsertDbRowOp op1 = new InsertDbRowOp(this.mockObject(id1), this.mockEntity("test4"), id1);
        InsertDbRowOp op2 = new InsertDbRowOp(this.mockObject(id2), this.mockEntity("test2"), id2);
        InsertDbRowOp op3 = new InsertDbRowOp(this.mockObject(id3), this.mockEntity("test3"), id3);
        InsertDbRowOp op4 = new InsertDbRowOp(this.mockObject(id4), this.mockEntity("test1"), id4);
        List<DbRowOp> rows = Arrays.asList(op1, op2, op3, op4);
        List<DbRowOp> expected = Arrays.asList(op4, op2, op3, op1);
        List<DbRowOp> sorted = this.sorter.sort(rows);
        Assert.assertEquals(expected, sorted);
    }

    @Test
    public void sortById() {
        ObjectId id1 = ObjectId.of("test", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 2);
        ObjectId id3 = ObjectId.of("test", "id", 2);
        ObjectId id4 = ObjectId.of("test", "id", 3);
        DbEntity test = this.mockEntity("test");
        InsertDbRowOp op1 = new InsertDbRowOp(this.mockObject(id1), test, id1);
        InsertDbRowOp op2 = new InsertDbRowOp(this.mockObject(id2), test, id2);
        DeleteDbRowOp op3 = new DeleteDbRowOp(this.mockObject(id3), test, id3);
        DeleteDbRowOp op4 = new DeleteDbRowOp(this.mockObject(id4), test, id4);
        List<DbRowOp> rows = Arrays.asList(op1, op2, op3, op4);
        List<DbRowOp> expected = Arrays.asList(op1, op2, op3, op4);
        List<DbRowOp> sorted = this.sorter.sort(rows);
        Assert.assertEquals(expected, sorted);
    }

    @Test
    public void sortByIdDifferentEntities() {
        ObjectId id1 = ObjectId.of("test2", "id", 1);
        ObjectId id2 = ObjectId.of("test", "id", 2);
        ObjectId id3 = ObjectId.of("test", "id", 2);
        ObjectId id4 = ObjectId.of("test", "id", 3);
        ObjectId id5 = ObjectId.of("test2", "id", 4);
        ObjectId id6 = ObjectId.of("test", "id", 5);
        ObjectId id7 = ObjectId.of("test", "id", 8);
        ObjectId id8 = ObjectId.of("test2", "id", 7);
        ObjectId id9 = ObjectId.of("test2", "id", 4);
        ObjectId id10 = ObjectId.of("test", "id", 8);
        DbEntity test = this.mockEntity("test");
        DbEntity test2 = this.mockEntity("test2");
        BaseDbRowOp[] op = new BaseDbRowOp[]{new InsertDbRowOp(this.mockObject(id1), test2, id1), new InsertDbRowOp(this.mockObject(id2), test, id2), new DeleteDbRowOp(this.mockObject(id3), test, id3), new UpdateDbRowOp(this.mockObject(id4), test, id4), new InsertDbRowOp(this.mockObject(id5), test2, id5), new DeleteDbRowOp(this.mockObject(id6), test, id6), new InsertDbRowOp(this.mockObject(id7), test, id7), new UpdateDbRowOp(this.mockObject(id8), test2, id8), new DeleteDbRowOp(this.mockObject(id9), test2, id9), new DeleteDbRowOp(this.mockObject(id10), test, id10)};
        List<DbRowOp> expected = Arrays.asList(op[1], op[6], op[0], op[4], op[3], op[7], op[8], op[2], op[5], op[9]);
        List<DbRowOp> sorted = this.sorter.sort(Arrays.asList(op));
        Assert.assertEquals(expected, sorted);
    }

    @Test
    public void sortReflexive() {
        ObjectId id1 = ObjectId.of("reflexive", "id", 1);
        ObjectId id2 = ObjectId.of("reflexive", "id", 2);
        ObjectId id3 = ObjectId.of("reflexive", "id", 3);
        ObjectId id4 = ObjectId.of("reflexive", "id", 4);
        DbEntity reflexive = this.mockEntity("reflexive");
        InsertDbRowOp op1 = new InsertDbRowOp(this.mockObject(id1), reflexive, id1);
        InsertDbRowOp op2 = new InsertDbRowOp(this.mockObject(id2), reflexive, id2);
        InsertDbRowOp op3 = new InsertDbRowOp(this.mockObject(id3), reflexive, id3);
        InsertDbRowOp op4 = new InsertDbRowOp(this.mockObject(id4), reflexive, id4);
        List<DbRowOp> rows = Arrays.asList(op1, op2, op3, op4);
        List<DbRowOp> expected = Arrays.asList(op1, op2, op3, op4);
        List<DbRowOp> sorted = this.sorter.sort(rows);
        Assert.assertEquals(expected, sorted);
        ((EntitySorter)Mockito.verify((Object)this.entitySorter)).sortObjectsForEntity((ObjEntity)Mockito.isNull(), (List)Mockito.any(List.class), Mockito.eq((boolean)false));
    }

    private Persistent mockObject(ObjectId id) {
        Persistent persistent = (Persistent)Mockito.mock(Persistent.class);
        Mockito.when((Object)persistent.getObjectId()).thenReturn((Object)id);
        Mockito.when((Object)persistent.getPersistenceState()).thenReturn((Object)4);
        return persistent;
    }

    private DbEntity mockEntity(String name) {
        DbAttribute attribute1 = new DbAttribute("id");
        attribute1.setPrimaryKey(true);
        DbAttribute attribute2 = new DbAttribute("attr");
        DbEntity testEntity = new DbEntity(name);
        testEntity.addAttribute(attribute1);
        testEntity.addAttribute(attribute2);
        return testEntity;
    }
}

