/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.numeric_types.BigDecimalEntity;
import org.apache.cayenne.testdo.numeric_types.BigIntegerEntity;
import org.apache.cayenne.testdo.numeric_types.BitTestEntity;
import org.apache.cayenne.testdo.numeric_types.BooleanTestEntity;
import org.apache.cayenne.testdo.numeric_types.DecimalPKTest1;
import org.apache.cayenne.testdo.numeric_types.DecimalPKTestEntity;
import org.apache.cayenne.testdo.numeric_types.LongEntity;
import org.apache.cayenne.testdo.numeric_types.SmallintTestEntity;
import org.apache.cayenne.testdo.numeric_types.TinyintTestEntity;
import org.apache.cayenne.unit.di.CommitStats;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-numeric-types.xml")
public class NumericTypesIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DataContext context1;
    @Inject
    protected ServerRuntime runtime;
    @Inject
    protected DBHelper dbHelper;
    private final CommitStats commitStats = new CommitStats(() -> this.runtime.getDataDomain());
    protected TableHelper tSmallintTest;
    protected TableHelper tTinyintTest;

    @Before
    public void before() {
        this.commitStats.before();
        this.tSmallintTest = new TableHelper(this.dbHelper, "SMALLINT_TEST");
        this.tSmallintTest.setColumns(new String[]{"ID", "SMALLINT_COL"});
        this.tTinyintTest = new TableHelper(this.dbHelper, "TINYINT_TEST");
        this.tTinyintTest.setColumns(new String[]{"ID", "TINYINT_COL"});
    }

    @After
    public void after() {
        this.commitStats.after();
    }

    protected void createShortDataSet() throws Exception {
        this.tSmallintTest.insert(new Object[]{1, 9999});
        this.tSmallintTest.insert(new Object[]{2, 3333});
    }

    protected void createTinyintDataSet() throws Exception {
        this.tTinyintTest.insert(new Object[]{1, 81});
        this.tTinyintTest.insert(new Object[]{2, 50});
    }

    @Test
    public void testLong() throws Exception {
        LongEntity test = this.context.newObject(LongEntity.class);
        Long i = 0x80000009L;
        test.setLongField(i);
        this.context.commitChanges();
        LongEntity testRead = ObjectSelect.query(LongEntity.class).selectFirst(this.context);
        Assert.assertNotNull((Object)testRead.getLongField());
        Assert.assertEquals((Object)i, (Object)testRead.getLongField());
        test.setLongField(null);
        this.context.commitChanges();
    }

    @Test
    public void testBigInteger() throws Exception {
        BigIntegerEntity test = this.context.newObject(BigIntegerEntity.class);
        BigInteger i = new BigInteger("1234567890");
        test.setBigIntegerField(i);
        this.context.commitChanges();
        BigIntegerEntity testRead = ObjectSelect.query(BigIntegerEntity.class).selectFirst(this.context);
        Assert.assertNotNull((Object)testRead.getBigIntegerField());
        Assert.assertEquals((Object)i, (Object)testRead.getBigIntegerField());
        test.setBigIntegerField(null);
        this.context.commitChanges();
    }

    @Test
    public void testBigDecimal_Decimal() {
        String v1 = "7890.123456";
        String v2 = "7890.1";
        String v2_padded = "7890.100000";
        BigDecimalEntity o = this.context.newObject(BigDecimalEntity.class);
        o.setBigDecimalDecimal(new BigDecimal(v1));
        o.getObjectContext().commitChanges();
        Assert.assertEquals((long)1L, (long)this.commitStats.getCommitCount());
        BigDecimalEntity o1 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertEquals((Object)v1, (Object)o1.getBigDecimalDecimal().toString());
        o.setBigDecimalDecimal(new BigDecimal(v2));
        o.getObjectContext().commitChanges();
        BigDecimalEntity o2 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertEquals((Object)v2_padded, (Object)o2.getBigDecimalDecimal().toString());
        Assert.assertEquals((long)2L, (long)this.commitStats.getCommitCount());
        o2.setBigDecimalDecimal(new BigDecimal(v2));
        o2.getObjectContext().commitChanges();
        Assert.assertEquals((String)"Commit was not expected. The difference is purely in value padding", (long)2L, (long)this.commitStats.getCommitCount());
        BigDecimalEntity o3 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertEquals((Object)v2_padded, (Object)o3.getBigDecimalDecimal().toString());
        o3.setBigDecimalDecimal(null);
        o3.getObjectContext().commitChanges();
        Assert.assertEquals((long)3L, (long)this.commitStats.getCommitCount());
        BigDecimalEntity o4 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertNull((Object)o4.getBigDecimalDecimal());
    }

    @Test
    public void testBigDecimal_Numeric() {
        String v1 = "1234567890.44";
        String v2 = "1234567890.4";
        String v2_padded = "1234567890.40";
        BigDecimalEntity o = this.context.newObject(BigDecimalEntity.class);
        o.setBigDecimalNumeric(new BigDecimal(v1));
        o.getObjectContext().commitChanges();
        Assert.assertEquals((long)1L, (long)this.commitStats.getCommitCount());
        BigDecimalEntity o1 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertEquals((Object)v1, (Object)o1.getBigDecimalNumeric().toString());
        o1.setBigDecimalNumeric(new BigDecimal(v2));
        o1.getObjectContext().commitChanges();
        Assert.assertEquals((long)2L, (long)this.commitStats.getCommitCount());
        BigDecimalEntity o2 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertEquals((Object)v2_padded, (Object)o2.getBigDecimalNumeric().toString());
        o2.setBigDecimalNumeric(new BigDecimal(v2));
        Assert.assertEquals((String)"Commit was not expected. The difference is purely in value padding", (long)2L, (long)this.commitStats.getCommitCount());
        BigDecimalEntity o3 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertEquals((Object)v2_padded, (Object)o3.getBigDecimalNumeric().toString());
        o3.setBigDecimalNumeric(null);
        o3.getObjectContext().commitChanges();
        Assert.assertEquals((long)3L, (long)this.commitStats.getCommitCount());
        BigDecimalEntity o4 = ObjectSelect.query(BigDecimalEntity.class).selectFirst(this.runtime.newContext());
        Assert.assertNull((Object)o4.getBigDecimalNumeric());
    }

    @Test
    public void testShortInQualifier() throws Exception {
        this.createShortDataSet();
        List objects = ObjectSelect.query(SmallintTestEntity.class).where(SmallintTestEntity.SMALLINT_COL.eq(Short.valueOf("9999"))).select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
        SmallintTestEntity object = (SmallintTestEntity)objects.get(0);
        Assert.assertEquals((Object)Short.valueOf("9999"), (Object)object.getSmallintCol());
    }

    @Test
    public void testShortInInsert() throws Exception {
        SmallintTestEntity object = (SmallintTestEntity)this.context.newObject("SmallintTestEntity");
        object.setSmallintCol(Short.valueOf("1"));
        this.context.commitChanges();
    }

    @Test
    public void testTinyintInQualifier() throws Exception {
        this.createTinyintDataSet();
        List objects = ObjectSelect.query(TinyintTestEntity.class).where(TinyintTestEntity.TINYINT_COL.eq((byte)81)).select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
        TinyintTestEntity object = (TinyintTestEntity)objects.get(0);
        Assert.assertEquals((Object)81, (Object)object.getTinyintCol());
    }

    @Test
    public void testTinyintInInsert() throws Exception {
        TinyintTestEntity object = (TinyintTestEntity)this.context.newObject("TinyintTestEntity");
        object.setTinyintCol((byte)1);
        this.context.commitChanges();
    }

    @Test
    public void testBooleanBit() throws Exception {
        BitTestEntity trueObject = (BitTestEntity)this.context.newObject("BitTestEntity");
        trueObject.setBitColumn(Boolean.TRUE);
        BitTestEntity falseObject = (BitTestEntity)this.context.newObject("BitTestEntity");
        falseObject.setBitColumn(Boolean.FALSE);
        this.context.commitChanges();
        this.context.invalidateObjects(trueObject, falseObject);
        List trueResult = ObjectSelect.query(BitTestEntity.class).where(BitTestEntity.BIT_COLUMN.eq(Boolean.TRUE)).select(this.context1);
        Assert.assertEquals((long)1L, (long)trueResult.size());
        BitTestEntity trueRefetched = (BitTestEntity)trueResult.get(0);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)trueRefetched.getBitColumn());
        Assert.assertNotSame((Object)trueRefetched, (Object)trueObject);
        Assert.assertSame((Object)Boolean.TRUE, (Object)trueRefetched.getBitColumn());
        List falseResult = ObjectSelect.query(BitTestEntity.class).where(BitTestEntity.BIT_COLUMN.eq(Boolean.FALSE)).select(this.context1);
        Assert.assertEquals((long)1L, (long)falseResult.size());
        BitTestEntity falseRefetched = (BitTestEntity)falseResult.get(0);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)falseRefetched.getBitColumn());
        Assert.assertNotSame((Object)falseRefetched, (Object)falseObject);
        Assert.assertSame((Object)Boolean.FALSE, (Object)falseRefetched.getBitColumn());
    }

    @Test
    public void testBooleanBoolean() throws Exception {
        BooleanTestEntity trueObject = (BooleanTestEntity)this.context.newObject("BooleanTestEntity");
        trueObject.setBooleanColumn(Boolean.TRUE);
        BooleanTestEntity falseObject = (BooleanTestEntity)this.context.newObject("BooleanTestEntity");
        falseObject.setBooleanColumn(Boolean.FALSE);
        this.context.commitChanges();
        this.context.invalidateObjects(trueObject, falseObject);
        List trueResult = ObjectSelect.query(BooleanTestEntity.class).where(BooleanTestEntity.BOOLEAN_COLUMN.eq(Boolean.TRUE)).select(this.context1);
        Assert.assertEquals((long)1L, (long)trueResult.size());
        BooleanTestEntity trueRefetched = (BooleanTestEntity)trueResult.get(0);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)trueRefetched.getBooleanColumn());
        Assert.assertNotSame((Object)trueRefetched, (Object)trueObject);
        Assert.assertSame((Object)Boolean.TRUE, (Object)trueRefetched.getBooleanColumn());
        List falseResult = ObjectSelect.query(BooleanTestEntity.class).where(BooleanTestEntity.BOOLEAN_COLUMN.eq(Boolean.FALSE)).select(this.context1);
        Assert.assertEquals((long)1L, (long)falseResult.size());
        BooleanTestEntity falseRefetched = (BooleanTestEntity)falseResult.get(0);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)falseRefetched.getBooleanColumn());
        Assert.assertNotSame((Object)falseRefetched, (Object)falseObject);
        Assert.assertSame((Object)Boolean.FALSE, (Object)falseRefetched.getBooleanColumn());
    }

    @Test
    public void testDecimalPK() throws Exception {
        DecimalPKTestEntity object = this.context.newObject(DecimalPKTestEntity.class);
        object.setName("o1");
        object.setDecimalPK(new BigDecimal("1.25"));
        this.context.commitChanges();
        ObjectId syntheticId = ObjectId.of("DecimalPKTestEntity", "DECIMAL_PK", new BigDecimal("1.25"));
        Assert.assertSame((Object)object, (Object)this.context.getGraphManager().getNode(syntheticId));
        this.context.deleteObjects(object);
        this.context.commitChanges();
    }

    @Test
    public void testDecimalPK1() throws Exception {
        DecimalPKTest1 object = this.context.newObject(DecimalPKTest1.class);
        object.setName("o2");
        object.setDecimalPK(1.25);
        this.context.commitChanges();
        ObjectId syntheticId = ObjectId.of("DecimalPKTest1", "DECIMAL_PK", 1.25);
        Assert.assertSame((Object)object, (Object)this.context.getGraphManager().getNode(syntheticId));
    }

    @Test
    public void testBigIntegerColumnSelect() {
        BigIntegerEntity test = this.context.newObject(BigIntegerEntity.class);
        BigInteger i = new BigInteger("1234567890");
        test.setBigIntegerField(i);
        this.context.commitChanges();
        BigInteger readValue = (BigInteger)ObjectSelect.query(BigIntegerEntity.class).column(BigIntegerEntity.BIG_INTEGER_FIELD).selectOne(this.context);
        Assert.assertEquals((Object)i, (Object)readValue);
        NumericProperty<BigInteger> calculated = PropertyFactory.createNumeric(ExpressionFactory.exp("bigIntegerField + 1", new Object[0]), BigInteger.class);
        BigInteger readValue2 = (BigInteger)ObjectSelect.query(BigIntegerEntity.class).column(calculated).selectOne(this.context);
        Assert.assertEquals((Object)i.add(BigInteger.ONE), (Object)readValue2);
    }
}

