/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Date;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.access.ToManyList;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContextReadIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DataContext context;
    @Inject
    private DataChannelInterceptor queryInterceptor;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, 12, -5, 3});
    }

    private void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
    }

    private void createRelationshipDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
        this.tPainting.insert(new Object[]{33001, "P_artist1", 33001, 3000});
        this.tPainting.insert(new Object[]{33002, "P_artist2", 33002, 3000});
        this.tPainting.insert(new Object[]{33003, "P_artist3", 33003, 3000});
        this.tPainting.insert(new Object[]{33004, "P_artist4", 33004, 3000});
        this.tPainting.insert(new Object[]{33005, "P_artist5", null, 3000});
    }

    private void createPrefetchingDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tPainting.insert(new Object[]{33001, "P_artist1", 33001, 3000});
        this.tPainting.insert(new Object[]{33006, "P_artist6", 33001, 3000});
    }

    @Test
    public void testCreateChildDataContext() {
        this.context.setValidatingObjectsOnCommit(true);
        ObjectContext child1 = this.runtime.newContext(this.context);
        Assert.assertNotNull((Object)child1);
        Assert.assertSame((Object)this.context, (Object)child1.getChannel());
        Assert.assertTrue((boolean)((DataContext)child1).isValidatingObjectsOnCommit());
        this.context.setValidatingObjectsOnCommit(false);
        ObjectContext child2 = this.runtime.newContext(this.context);
        Assert.assertNotNull((Object)child2);
        Assert.assertSame((Object)this.context, (Object)child2.getChannel());
        Assert.assertFalse((boolean)((DataContext)child2).isValidatingObjectsOnCommit());
        ObjectContext child21 = this.runtime.newContext(child2);
        Assert.assertNotNull((Object)child21);
        Assert.assertSame((Object)child2, (Object)child21.getChannel());
        Assert.assertFalse((boolean)((DataContext)child2).isValidatingObjectsOnCommit());
    }

    @Test
    public void testSelect() throws Exception {
        this.createArtistsDataSet();
        ObjectContext child = this.runtime.newContext(this.context);
        Persistent _new = this.context.newObject(Artist.class);
        Persistent hollow = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33001);
        this.context.invalidateObjects(hollow);
        DataObject committed = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33002);
        Artist modified = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33003);
        modified.setArtistName("MODDED");
        DataObject deleted = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33004);
        this.context.deleteObjects(deleted);
        Assert.assertEquals((long)5L, (long)hollow.getPersistenceState());
        Assert.assertEquals((long)3L, (long)committed.getPersistenceState());
        Assert.assertEquals((long)4L, (long)modified.getPersistenceState());
        Assert.assertEquals((long)6L, (long)deleted.getPersistenceState());
        Assert.assertEquals((long)2L, (long)_new.getPersistenceState());
        List objects = ObjectSelect.query(Artist.class).select(child);
        Assert.assertEquals((String)"All but NEW object must have been included", (long)4L, (long)objects.size());
        for (Artist next : objects) {
            Assert.assertEquals((long)3L, (long)next.getPersistenceState());
            int id = Cayenne.intPKForObject(next);
            if (id != 33003) continue;
            Assert.assertEquals((Object)"MODDED", (Object)next.getArtistName());
        }
    }

    @Test
    public void testPageableSelect() throws Exception {
        this.createArtistsDataSet();
        ObjectContext child = this.runtime.newContext(this.context);
        IncrementalFaultList records = (IncrementalFaultList)ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_NAME.desc()).pageSize(1).select(child);
        Assert.assertEquals((long)4L, (long)records.size());
        Assert.assertEquals((long)1L, (long)records.getPageSize());
    }

    @Test
    public void testReadToOneRelationship() throws Exception {
        this.createRelationshipDataSet();
        ObjectContext child = this.runtime.newContext(this.context);
        Painting hollowTargetSrc = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33001);
        Artist hollowTarget = hollowTargetSrc.getToArtist();
        Painting modifiedTargetSrc = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33002);
        Artist modifiedTarget = modifiedTargetSrc.getToArtist();
        modifiedTarget.setArtistName("M1");
        Painting deletedTargetSrc = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33003);
        Artist deletedTarget = deletedTargetSrc.getToArtist();
        deletedTargetSrc.setToArtist(null);
        this.context.deleteObjects(deletedTarget);
        Painting committedTargetSrc = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33004);
        Artist committedTarget = committedTargetSrc.getToArtist();
        committedTarget.getArtistName();
        Painting newTargetSrc = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33005);
        Artist newTarget = this.context.newObject(Artist.class);
        newTarget.setArtistName("N1");
        newTargetSrc.setToArtist(newTarget);
        Assert.assertEquals((long)3L, (long)hollowTargetSrc.getPersistenceState());
        Assert.assertEquals((long)3L, (long)modifiedTargetSrc.getPersistenceState());
        Assert.assertEquals((long)4L, (long)deletedTargetSrc.getPersistenceState());
        Assert.assertEquals((long)3L, (long)committedTargetSrc.getPersistenceState());
        Assert.assertEquals((long)4L, (long)newTargetSrc.getPersistenceState());
        Assert.assertEquals((long)5L, (long)hollowTarget.getPersistenceState());
        Assert.assertEquals((long)4L, (long)modifiedTarget.getPersistenceState());
        Assert.assertEquals((long)6L, (long)deletedTarget.getPersistenceState());
        Assert.assertEquals((long)3L, (long)committedTarget.getPersistenceState());
        Assert.assertEquals((long)2L, (long)newTarget.getPersistenceState());
        List childSources = ObjectSelect.query(Painting.class).orderBy(Painting.PAINTING_TITLE.asc()).select(child);
        Assert.assertEquals((long)5L, (long)childSources.size());
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Painting childHollowTargetSrc = (Painting)childSources.get(0);
            Assert.assertSame((Object)child, (Object)childHollowTargetSrc.getObjectContext());
            Artist childHollowTarget = childHollowTargetSrc.getToArtist();
            Assert.assertNotNull((Object)childHollowTarget);
            Assert.assertEquals((long)5L, (long)childHollowTarget.getPersistenceState());
            Assert.assertSame((Object)child, (Object)childHollowTarget.getObjectContext());
            Artist childModifiedTarget = ((Painting)childSources.get(1)).getToArtist();
            Assert.assertEquals((long)3L, (long)childModifiedTarget.getPersistenceState());
            Assert.assertSame((Object)child, (Object)childModifiedTarget.getObjectContext());
            Assert.assertEquals((Object)"M1", (Object)childModifiedTarget.getArtistName());
            Painting childDeletedTargetSrc = (Painting)childSources.get(2);
            Assert.assertEquals((Object)deletedTargetSrc.getObjectId(), (Object)childDeletedTargetSrc.getObjectId());
            Artist childDeletedTarget = childDeletedTargetSrc.getToArtist();
            Assert.assertNull((Object)childDeletedTarget);
            Artist childCommittedTarget = ((Painting)childSources.get(3)).getToArtist();
            Assert.assertEquals((long)3L, (long)childCommittedTarget.getPersistenceState());
            Assert.assertSame((Object)child, (Object)childCommittedTarget.getObjectContext());
            Painting childNewTargetSrc = (Painting)childSources.get(4);
            Assert.assertEquals((Object)newTargetSrc.getObjectId(), (Object)childNewTargetSrc.getObjectId());
            Artist childNewTarget = childNewTargetSrc.getToArtist();
            Assert.assertNotNull((Object)childNewTarget);
            Assert.assertEquals((long)3L, (long)childNewTarget.getPersistenceState());
            Assert.assertSame((Object)child, (Object)childNewTarget.getObjectContext());
            Assert.assertEquals((Object)"N1", (Object)childNewTarget.getArtistName());
        });
    }

    @Test
    public void testPrefetchingToOne() throws Exception {
        this.createPrefetchingDataSet();
        ObjectContext child = this.runtime.newContext(this.context);
        ObjectId prefetchedId = ObjectId.of("Artist", "ARTIST_ID", 33001);
        List results = ObjectSelect.query(Painting.class).orderBy(Painting.PAINTING_TITLE.asc()).prefetch(Painting.TO_ARTIST.disjoint()).select(child);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)results.size());
            for (Painting o : results) {
                Assert.assertEquals((long)3L, (long)o.getPersistenceState());
                Assert.assertSame((Object)child, (Object)o.getObjectContext());
                Artist o1 = o.getToArtist();
                Assert.assertNotNull((Object)o1);
                Assert.assertEquals((long)3L, (long)o1.getPersistenceState());
                Assert.assertSame((Object)child, (Object)o1.getObjectContext());
                Assert.assertEquals((Object)prefetchedId, (Object)o1.getObjectId());
            }
        });
    }

    @Test
    public void testPrefetchingToMany() throws Exception {
        this.createPrefetchingDataSet();
        ObjectContext child = this.runtime.newContext(this.context);
        List results = ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_NAME.asc()).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(child);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Artist o1 = (Artist)results.get(0);
            Assert.assertEquals((long)3L, (long)o1.getPersistenceState());
            Assert.assertSame((Object)child, (Object)o1.getObjectContext());
            List<Painting> children1 = o1.getPaintingArray();
            Assert.assertEquals(ToManyList.class, children1.getClass());
            Assert.assertEquals((long)2L, (long)children1.size());
            for (Painting o : children1) {
                Assert.assertEquals((long)3L, (long)o.getPersistenceState());
                Assert.assertSame((Object)child, (Object)o.getObjectContext());
                Assert.assertEquals((Object)o1, (Object)o.getToArtist());
            }
            Artist o2 = (Artist)results.get(1);
            Assert.assertEquals((long)3L, (long)o2.getPersistenceState());
            Assert.assertSame((Object)child, (Object)o2.getObjectContext());
            List<Painting> children2 = o2.getPaintingArray();
            Assert.assertEquals((long)0L, (long)children2.size());
        });
    }

    @Test
    public void testObjectFromDataRow() {
        DataContext childContext = (DataContext)this.runtime.newContext(this.context);
        DataRow row = new DataRow(8);
        row.put("ARTIST_ID", 5L);
        row.put("ARTIST_NAME", "A");
        row.put("DATE_OF_BIRTH", new Date());
        Artist artist = childContext.objectFromDataRow(Artist.class, row);
        Assert.assertNotNull((Object)artist);
        Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
        Assert.assertSame((Object)childContext, (Object)artist.getObjectContext());
        Object parentArtist = this.context.getObjectStore().getNode(artist.getObjectId());
        Assert.assertNotNull((Object)parentArtist);
        Assert.assertNotSame((Object)artist, (Object)parentArtist);
    }
}

