/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Fault;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowUtils;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest3;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-flattened.xml")
public class FlattenedRelationshipInContextIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    private TableHelper tFlattenedTest1;
    private TableHelper tFlattenedTest2;
    private TableHelper tFlattenedTest3;

    @Before
    public void setUp() throws Exception {
        this.tFlattenedTest1 = new TableHelper(this.dbHelper, "FLATTENED_TEST_1");
        this.tFlattenedTest1.setColumns(new String[]{"FT1_ID", "NAME"});
        this.tFlattenedTest2 = new TableHelper(this.dbHelper, "FLATTENED_TEST_2");
        this.tFlattenedTest2.setColumns(new String[]{"FT2_ID", "FT1_ID", "NAME"});
        this.tFlattenedTest3 = new TableHelper(this.dbHelper, "FLATTENED_TEST_3");
        this.tFlattenedTest3.setColumns(new String[]{"FT3_ID", "FT2_ID", "NAME"});
    }

    protected void createFlattenedTestDataSet() throws Exception {
        this.tFlattenedTest1.insert(new Object[]{1, "ft1"});
        this.tFlattenedTest1.insert(new Object[]{2, "ft12"});
        this.tFlattenedTest2.insert(new Object[]{1, 1, "ft2"});
        this.tFlattenedTest3.insert(new Object[]{1, 1, "ft3"});
    }

    @Test
    public void testIsToOneTargetModifiedFlattenedFault1() throws Exception {
        this.createFlattenedTestDataSet();
        List ft3s = ObjectSelect.query(FlattenedTest3.class).select(this.context);
        Assert.assertEquals((long)1L, (long)ft3s.size());
        FlattenedTest3 ft3 = (FlattenedTest3)ft3s.get(0);
        ft3.setPersistenceState(4);
        Assert.assertTrue((boolean)(ft3.readPropertyDirectly("toFT1") instanceof Fault));
        ClassDescriptor d = this.context.getEntityResolver().getClassDescriptor("FlattenedTest3");
        ArcProperty flattenedRel = (ArcProperty)d.getProperty("toFT1");
        ObjectDiff diff = this.context.getObjectStore().registerDiff(ft3.getObjectId(), null);
        Assert.assertFalse((boolean)DataRowUtils.isToOneTargetModified(flattenedRel, ft3, diff));
        Assert.assertTrue((boolean)(ft3.readPropertyDirectly("toFT1") instanceof Fault));
    }
}

