/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashSet;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class FlattenedPrefetchIT
extends ServerCase {
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tArtgroup;
    protected TableHelper tArtistGroup;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
        this.tArtgroup = new TableHelper(this.dbHelper, "ARTGROUP");
        this.tArtgroup.setColumns(new String[]{"GROUP_ID", "NAME"});
        this.tArtistGroup = new TableHelper(this.dbHelper, "ARTIST_GROUP");
        this.tArtistGroup.setColumns(new String[]{"ARTIST_ID", "GROUP_ID"});
    }

    protected void createPrefetchDataSet1() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtgroup.insert(new Object[]{33001, "group1"});
        this.tArtgroup.insert(new Object[]{33002, "group2"});
        this.tArtistGroup.insert(new Object[]{33001, 33001});
        this.tArtistGroup.insert(new Object[]{33001, 33002});
        this.tArtistGroup.insert(new Object[]{33002, 33002});
        this.tArtistGroup.insert(new Object[]{33003, 33002});
    }

    protected void createPrefetchDataSet2() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtgroup.insert(new Object[]{33001, "group1"});
        this.tArtgroup.insert(new Object[]{33002, "group2"});
        this.tArtistGroup.insert(new Object[]{33001, 33001});
        this.tArtistGroup.insert(new Object[]{33001, 33002});
        this.tArtistGroup.insert(new Object[]{33002, 33002});
        this.tArtistGroup.insert(new Object[]{33003, 33002});
        this.tPainting.insert(new Object[]{33001, "P_artist11", 33001, 1000});
        this.tPainting.insert(new Object[]{33002, "P_artist12", 33001, 2000});
        this.tPainting.insert(new Object[]{33003, "P_artist21", 33002, 3000});
    }

    @Test
    public void testManyToMany() throws Exception {
        this.createPrefetchDataSet1();
        List objects = ObjectSelect.query(Artist.class).prefetch(Artist.GROUP_ARRAY.disjoint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> this.assertArtistResult(objects));
    }

    @Test
    public void testMultiPrefetch() throws Exception {
        this.createPrefetchDataSet2();
        List objects = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).prefetch(Painting.TO_ARTIST.dot(Artist.GROUP_ARRAY).disjoint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> this.assertPaintingResult(objects));
    }

    @Test
    public void testJointManyToMany() throws Exception {
        this.createPrefetchDataSet1();
        List objects = ObjectSelect.query(Artist.class).prefetch(Artist.GROUP_ARRAY.joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> this.assertArtistResult(objects));
    }

    @Test
    public void testJointMultiPrefetch() throws Exception {
        this.createPrefetchDataSet2();
        List objects = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint()).prefetch(Painting.TO_ARTIST.dot(Artist.GROUP_ARRAY).joint()).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> this.assertPaintingResult(objects));
    }

    private void assertArtistResult(List<Artist> objects) {
        Assert.assertEquals((long)3L, (long)objects.size());
        for (Artist a : objects) {
            this.assertArtGroupResult(a.getGroupArray());
        }
    }

    private void assertPaintingResult(List<Painting> objects) {
        Assert.assertEquals((long)3L, (long)objects.size());
        for (Painting p : objects) {
            Artist a = p.getToArtist();
            Assert.assertEquals((long)3L, (long)a.getPersistenceState());
            this.assertArtGroupResult(a.getGroupArray());
        }
    }

    private void assertArtGroupResult(List<ArtGroup> list) {
        Assert.assertNotNull(list);
        Assert.assertFalse((String)"artist's groups not resolved: ", (boolean)((ValueHolder)((Object)list)).isFault());
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        for (ArtGroup g : list) {
            Assert.assertEquals((long)3L, (long)g.getPersistenceState());
        }
        HashSet<ArtGroup> s = new HashSet<ArtGroup>(list);
        Assert.assertEquals((long)s.size(), (long)list.size());
    }
}

