/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.unit.util.ValidationDelegate;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextValidationIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testValidatingObjectsOnCommitProperty() throws Exception {
        this.context.setValidatingObjectsOnCommit(true);
        Assert.assertTrue((boolean)this.context.isValidatingObjectsOnCommit());
        this.context.setValidatingObjectsOnCommit(false);
        Assert.assertFalse((boolean)this.context.isValidatingObjectsOnCommit());
    }

    @Test
    public void testValidatingObjectsOnCommit() throws Exception {
        this.context.setValidatingObjectsOnCommit(true);
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        this.context.commitChanges();
        Assert.assertTrue((boolean)a1.isValidateForSaveCalled());
        this.context.setValidatingObjectsOnCommit(false);
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("a2");
        this.context.commitChanges();
        Assert.assertFalse((boolean)a2.isValidateForSaveCalled());
    }

    @Test
    public void testValidationModifyingContext() throws Exception {
        ValidationDelegate delegate = (object, validationResult) -> {
            Artist a = (Artist)object;
            Painting p = a.getObjectContext().newObject(Painting.class);
            p.setPaintingTitle("XXX");
            p.setToArtist(a);
        };
        this.context.setValidatingObjectsOnCommit(true);
        Artist a1 = this.context.newObject(Artist.class);
        a1.setValidationDelegate(delegate);
        a1.setArtistName("a1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setValidationDelegate(delegate);
        a2.setArtistName("a2");
        this.context.commitChanges();
        Assert.assertEquals((long)2L, (long)ObjectSelect.query(Painting.class).select(this.context).size());
    }
}

