/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_people.AbstractPerson;
import org.apache.cayenne.testdo.inheritance_people.CustomerRepresentative;
import org.apache.cayenne.testdo.inheritance_people.Employee;
import org.apache.cayenne.testdo.inheritance_people.Manager;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataContextQualifiedEntityIT
extends PeopleProjectCase {
    @Inject
    protected ObjectContext context;
    protected TableHelper tPerson;

    @Before
    public void setUp() throws Exception {
        this.dbHelper.update("PERSON").set("DEPARTMENT_ID", null, 4).execute();
        this.tPerson = new TableHelper(this.dbHelper, "PERSON");
        this.tPerson.setColumns(new String[]{"CLIENT_COMPANY_ID", "CLIENT_CONTACT_TYPE", "DEPARTMENT_ID", "NAME", "PERSON_ID", "PERSON_TYPE", "SALARY"}).setColumnTypes(new int[]{4, 12, 4, 12, 4, 1, 6});
    }

    protected void createPersonsDataSet() throws Exception {
        this.tPerson.insert(new Object[]{null, null, null, "e1", 1, "EE", 20000});
        this.tPerson.insert(new Object[]{null, null, null, "e2", 2, "EE", 25000});
        this.tPerson.insert(new Object[]{null, null, null, "e3", 3, "EE", 28000});
        this.tPerson.insert(new Object[]{null, null, null, "m1", 4, "EM", 30000});
        this.tPerson.insert(new Object[]{null, null, null, "m2", 5, "EM", 40000});
        this.tPerson.insert(new Object[]{null, null, null, "c1", 6, "C", null});
    }

    @Test
    public void testSelect() throws Exception {
        this.createPersonsDataSet();
        List abstractPpl = ObjectSelect.query(AbstractPerson.class).select(this.context);
        Assert.assertEquals((long)6L, (long)abstractPpl.size());
        List customerReps = ObjectSelect.query(CustomerRepresentative.class).select(this.context);
        Assert.assertEquals((long)1L, (long)customerReps.size());
        List employees = ObjectSelect.query(Employee.class).select(this.context);
        Assert.assertEquals((long)5L, (long)employees.size());
        List managers = ObjectSelect.query(Manager.class).select(this.context);
        Assert.assertEquals((long)2L, (long)managers.size());
    }

    @Test
    public void testPrefetch() throws Exception {
        this.createPersonsDataSet();
        List managers = ObjectSelect.query(Manager.class).select(this.context);
        Assert.assertEquals((long)2L, (long)managers.size());
    }
}

