/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.compound.CharFkTestEntity;
import org.apache.cayenne.testdo.compound.CharPkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundFkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class DataContextPrefetchExtrasIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tCharPkTest;
    protected TableHelper tCharFkTest;
    protected TableHelper tCompoundPkTest;
    protected TableHelper tCompoundFkTest;

    @Before
    public void setUp() throws Exception {
        this.tCharPkTest = new TableHelper(this.dbHelper, "CHAR_PK_TEST");
        this.tCharPkTest.setColumns(new String[]{"PK_COL", "OTHER_COL"});
        this.tCharFkTest = new TableHelper(this.dbHelper, "CHAR_FK_TEST");
        this.tCharFkTest.setColumns(new String[]{"PK", "FK_COL", "NAME"});
        this.tCompoundPkTest = new TableHelper(this.dbHelper, "COMPOUND_PK_TEST");
        this.tCompoundPkTest.setColumns(new String[]{"KEY1", "KEY2", "NAME"});
        this.tCompoundFkTest = new TableHelper(this.dbHelper, "COMPOUND_FK_TEST");
        this.tCompoundFkTest.setColumns(new String[]{"PKEY", "F_KEY1", "F_KEY2", "NAME"});
    }

    protected void createPrefetchToManyOnCharKeyDataSet() throws Exception {
        this.tCharPkTest.insert(new Object[]{"k1", "n1"});
        this.tCharPkTest.insert(new Object[]{"k2", "n2"});
        this.tCharFkTest.insert(new Object[]{1, "k1", "fn1"});
        this.tCharFkTest.insert(new Object[]{2, "k1", "fn2"});
        this.tCharFkTest.insert(new Object[]{3, "k2", "fn3"});
        this.tCharFkTest.insert(new Object[]{4, "k2", "fn4"});
        this.tCharFkTest.insert(new Object[]{5, "k1", "fn5"});
    }

    protected void createCompoundDataSet() throws Exception {
        this.tCompoundPkTest.insert(new Object[]{"101", "201", "CPK1"});
        this.tCompoundPkTest.insert(new Object[]{"102", "202", "CPK2"});
        this.tCompoundPkTest.insert(new Object[]{"103", "203", "CPK3"});
        this.tCompoundFkTest.insert(new Object[]{301, "102", "202", "CFK1"});
        this.tCompoundFkTest.insert(new Object[]{302, "102", "202", "CFK2"});
        this.tCompoundFkTest.insert(new Object[]{303, "101", "201", "CFK3"});
    }

    @Test
    public void testPrefetchToManyOnCharKey() throws Exception {
        this.createPrefetchToManyOnCharKeyDataSet();
        ObjectSelect<CharPkTestEntity> q = ObjectSelect.query(CharPkTestEntity.class).prefetch("charFKs", 0).orderBy(CharPkTestEntity.OTHER_COL.asc());
        List pks = q.select(this.context);
        Assert.assertEquals((long)2L, (long)pks.size());
        CharPkTestEntity pk1 = (CharPkTestEntity)pks.get(0);
        Assert.assertEquals((Object)"n1", (Object)pk1.getOtherCol());
        List toMany = (List)pk1.readPropertyDirectly("charFKs");
        Assert.assertNotNull((Object)toMany);
        Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
        Assert.assertEquals((long)3L, (long)toMany.size());
        CharFkTestEntity fk1 = (CharFkTestEntity)toMany.get(0);
        Assert.assertEquals((long)3L, (long)fk1.getPersistenceState());
        Assert.assertSame((Object)pk1, (Object)fk1.getToCharPK());
    }

    @Test
    public void testPrefetch10() throws Exception {
        this.createCompoundDataSet();
        ObjectSelect<CompoundFkTestEntity> q = ObjectSelect.query(CompoundFkTestEntity.class).where(CompoundFkTestEntity.NAME.eq("CFK2")).prefetch("toCompoundPk", 0);
        List objects = q.select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
        BaseDataObject fk1 = (BaseDataObject)objects.get(0);
        Object toOnePrefetch = fk1.readNestedProperty("toCompoundPk");
        Assert.assertNotNull((Object)toOnePrefetch);
        Assert.assertTrue((String)("Expected DataObject, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof DataObject));
        DataObject pk1 = (DataObject)toOnePrefetch;
        Assert.assertEquals((long)3L, (long)pk1.getPersistenceState());
        Assert.assertEquals((Object)"CPK2", (Object)pk1.readPropertyDirectly("name"));
    }

    @Test
    public void testPrefetch11() throws Exception {
        this.createCompoundDataSet();
        ObjectSelect<CompoundPkTestEntity> q = ObjectSelect.query(CompoundPkTestEntity.class).where(CompoundPkTestEntity.NAME.eq("CPK2")).prefetch("compoundFkArray", 0);
        List pks = q.select(this.context);
        Assert.assertEquals((long)1L, (long)pks.size());
        BaseDataObject pk1 = (BaseDataObject)pks.get(0);
        List toMany = (List)pk1.readPropertyDirectly("compoundFkArray");
        Assert.assertNotNull((Object)toMany);
        Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
        Assert.assertEquals((long)2L, (long)toMany.size());
        BaseDataObject fk1 = (BaseDataObject)toMany.get(0);
        Assert.assertEquals((long)3L, (long)fk1.getPersistenceState());
        BaseDataObject fk2 = (BaseDataObject)toMany.get(1);
        Assert.assertEquals((long)3L, (long)fk2.getPersistenceState());
    }
}

