/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.Date;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextObjectIdQueryIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testRefreshNullifiedValuesNew() {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        a.setDateOfBirth(new Date());
        this.context.commitChanges();
        this.context.performGenericQuery(new SQLTemplate(Artist.class, "UPDATE ARTIST SET DATE_OF_BIRTH = NULL"));
        long id = Cayenne.longPKForObject(a);
        ObjectIdQuery query = new ObjectIdQuery(ObjectId.of("Artist", "ARTIST_ID", id), false, 2);
        Artist a1 = (Artist)Cayenne.objectForQuery(this.context, query);
        Assert.assertNull((Object)a1.getDateOfBirth());
        Assert.assertEquals((Object)"X", (Object)a1.getArtistName());
    }

    @Test
    public void testNoRefreshValuesNew() {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        this.context.commitChanges();
        this.context.performGenericQuery(new SQLTemplate(Artist.class, "UPDATE ARTIST SET ARTIST_NAME = 'Y'"));
        long id = Cayenne.longPKForObject(a);
        ObjectIdQuery query = new ObjectIdQuery(ObjectId.of("Artist", "ARTIST_ID", id), false, 1);
        Artist a1 = (Artist)Cayenne.objectForQuery(this.context, query);
        Assert.assertEquals((Object)"X", (Object)a1.getArtistName());
    }

    @Test
    public void testRefreshNullifiedValuesExisting() {
        SQLTemplate insert = new SQLTemplate(Artist.class, "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (44, 'X', #bind($date 'DATE'))");
        insert.setParameters(Collections.singletonMap("date", new Date()));
        this.context.performGenericQuery(insert);
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, (Object)44L);
        Assert.assertNotNull((Object)a.getDateOfBirth());
        Assert.assertEquals((Object)"X", (Object)a.getArtistName());
        this.context.performGenericQuery(new SQLTemplate(Artist.class, "UPDATE ARTIST SET DATE_OF_BIRTH = NULL"));
        ObjectIdQuery query = new ObjectIdQuery(ObjectId.of("Artist", "ARTIST_ID", 44L), false, 2);
        Artist a1 = (Artist)Cayenne.objectForQuery(this.context, query);
        Assert.assertNull((Object)a1.getDateOfBirth());
        Assert.assertEquals((Object)"X", (Object)a1.getArtistName());
    }
}

