/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.no_pk.NoPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-no-pk.xml")
public class DataContextNoPkIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;

    @Before
    public void setUp() throws Exception {
        TableHelper noPkTestTable = new TableHelper(this.dbHelper, "NO_PK_TEST", new String[]{"ATTRIBUTE1"});
        noPkTestTable.deleteAll();
        noPkTestTable.insert(new Object[]{1});
        noPkTestTable.insert(new Object[]{2});
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testNoPkFetchObjects() {
        ObjectSelect.query(NoPkTestEntity.class).select(this.context);
    }

    @Test
    public void testNoPkFetchDataRows() {
        List rows = ObjectSelect.dataRowQuery(NoPkTestEntity.class).select(this.context);
        Assert.assertNotNull(rows);
        Assert.assertEquals((long)2L, (long)rows.size());
        DataRow row1 = (DataRow)rows.get(0);
        DataRow row2 = (DataRow)rows.get(1);
        Assert.assertTrue((!row1.get("ATTRIBUTE1").equals(row2.get("ATTRIBUTE1")) ? 1 : 0) != 0);
    }
}

