/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextIteratedQueryIT
extends ServerCase {
    @Inject
    protected DBHelper dbHelper;
    @Inject
    private DataContext context;
    private TableHelper tArtist;
    private TableHelper tExhibit;
    private TableHelper tGallery;
    private TableHelper tPainting;

    @Before
    public void before() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tExhibit = new TableHelper(this.dbHelper, "EXHIBIT");
        this.tExhibit.setColumns(new String[]{"EXHIBIT_ID", "GALLERY_ID", "OPENING_DATE", "CLOSING_DATE"});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
    }

    private void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
        this.tArtist.insert(new Object[]{33005, "artist5"});
        this.tArtist.insert(new Object[]{33006, "artist11"});
        this.tArtist.insert(new Object[]{33007, "artist21"});
    }

    protected void createArtistsAndPaintingsDataSet() throws Exception {
        this.createArtistsDataSet();
        this.tPainting.insert(new Object[]{33001, "P_artist1", 33001, 1000});
        this.tPainting.insert(new Object[]{33002, "P_artist2", 33002, 2000});
        this.tPainting.insert(new Object[]{33003, "P_artist3", 33003, 3000});
        this.tPainting.insert(new Object[]{33004, "P_artist4", 33004, 4000});
        this.tPainting.insert(new Object[]{33005, "P_artist5", 33005, 5000});
        this.tPainting.insert(new Object[]{33006, "P_artist11", 33006, 11000});
        this.tPainting.insert(new Object[]{33007, "P_artist21", 33007, 21000});
    }

    private void createLargeArtistsDataSet() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.tArtist.insert(new Object[]{i, "artist" + i});
        }
    }

    @Test
    public void testIterate() throws Exception {
        this.createArtistsDataSet();
        int[] count = new int[1];
        ObjectSelect.query(Artist.class).iterate(this.context, object -> {
            Assert.assertNotNull((Object)object.getArtistName());
            count[0] = count[0] + 1;
        });
        Assert.assertEquals((long)7L, (long)count[0]);
    }

    @Test
    public void testIterateDataRows() throws Exception {
        this.createArtistsDataSet();
        int[] count = new int[1];
        ObjectSelect.dataRowQuery(Artist.class).iterate(this.context, object -> {
            Assert.assertNotNull(object.get("ARTIST_ID"));
            count[0] = count[0] + 1;
        });
        Assert.assertEquals((long)7L, (long)count[0]);
    }

    @Test
    public void testIterator() throws Exception {
        this.createArtistsDataSet();
        try (ResultIterator it = ObjectSelect.query(Artist.class).iterator(this.context);){
            int count = 0;
            for (Artist a : it) {
                ++count;
            }
            Assert.assertEquals((long)7L, (long)count);
        }
    }

    @Test
    public void testBatchIterator() throws Exception {
        this.createLargeArtistsDataSet();
        try (ResultBatchIterator it = ObjectSelect.query(Artist.class).batchIterator(this.context, 5);){
            int count = 0;
            for (List artistList : it) {
                ++count;
                Assert.assertEquals((long)5L, (long)artistList.size());
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void testPerformIteratedQuery_Count() throws Exception {
        this.createArtistsDataSet();
        try (ResultIterator it = this.context.performIteratedQuery(ObjectSelect.query(Artist.class));){
            int count = 0;
            while (it.hasNextRow()) {
                it.nextRow();
                ++count;
            }
            Assert.assertEquals((long)7L, (long)count);
        }
    }

    @Test
    public void testPerformIteratedQuery_resolve() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        try (ResultIterator it = this.context.performIteratedQuery(ObjectSelect.query(Artist.class));){
            while (it.hasNextRow()) {
                DataRow row = (DataRow)it.nextRow();
                Artist artist = this.context.objectFromDataRow(Artist.class, row);
                List<Painting> paintings = artist.getPaintingArray();
                Assert.assertNotNull(paintings);
                Assert.assertEquals((String)("Expected one painting for artist: " + artist), (long)1L, (long)paintings.size());
            }
        }
    }

    @Test
    public void testPerformIteratedQuery_CommitWithinIterator() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        Assert.assertEquals((long)7L, (long)this.tPainting.getRowCount());
        try (ResultIterator it = this.context.performIteratedQuery(ObjectSelect.query(Artist.class));){
            while (it.hasNextRow()) {
                DataRow row = (DataRow)it.nextRow();
                Artist artist = this.context.objectFromDataRow(Artist.class, row);
                Painting painting = this.context.newObject(Painting.class);
                painting.setPaintingTitle("P_" + artist.getArtistName());
                painting.setToArtist(artist);
                this.context.commitChanges();
            }
        }
        Assert.assertEquals((long)14L, (long)this.tPainting.getRowCount());
    }

    @Test
    public void testPerformIteratedQuery_Transaction() throws Exception {
        this.createArtistsDataSet();
        try (ResultIterator it = this.context.performIteratedQuery(ObjectSelect.query(Artist.class));){
            Assert.assertNull((String)"Iterator transaction was not unbound from thread", (Object)BaseTransaction.getThreadTransaction());
        }
    }
}

