/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.meaningful_pk.MeaningfulPKDep;
import org.apache.cayenne.testdo.meaningful_pk.MeaningfulPKTest1;
import org.apache.cayenne.testdo.meaningful_pk.MeaningfulPk;
import org.apache.cayenne.testdo.meaningful_pk.MeaningfulPkDep2;
import org.apache.cayenne.testdo.meaningful_pk.MeaningfulPkTest2;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@UseServerRuntime(value="cayenne-meaningful-pk.xml")
public class DataContextEntityWithMeaningfulPKIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testInsertWithMeaningfulPK() {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setPkAttribute(1000);
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        ObjectId objId = ObjectId.of("MeaningfulPKTest1", "PK_ATTRIBUTE", 1000);
        ObjectIdQuery q = new ObjectIdQuery(objId, true, 2);
        List result = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)1000, ((DataRow)result.get(0)).get("PK_ATTRIBUTE"));
    }

    @Test
    public void testGeneratedKey() {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        Assert.assertNotEquals((long)0L, (long)obj.getPkAttribute());
        Assert.assertSame((Object)obj, (Object)Cayenne.objectForPK((ObjectContext)this.context, MeaningfulPKTest1.class, obj.getPkAttribute()));
        int id = Cayenne.intPKForObject(obj);
        DataRow snapshot = this.context.getObjectStore().getDataRowCache().getCachedSnapshot(obj.getObjectId());
        Assert.assertNotNull((Object)snapshot);
        Assert.assertTrue((boolean)snapshot.containsKey("PK_ATTRIBUTE"));
        Assert.assertEquals((Object)id, snapshot.get("PK_ATTRIBUTE"));
    }

    @Test
    public void testChangeKey() {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setPkAttribute(1000);
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        obj.setPkAttribute(2000);
        this.context.commitChanges();
        ObjectId id = obj.getObjectId();
        Assert.assertEquals((Object)2000, (Object)id.getIdSnapshot().get("PK_ATTRIBUTE"));
    }

    @Test
    public void testToManyRelationshipWithMeaningfulPK1() {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setPkAttribute(1000);
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        ObjectContext context = this.runtime.newContext();
        List objects = ObjectSelect.query(MeaningfulPKTest1.class).select(context);
        Assert.assertEquals((long)1L, (long)objects.size());
        obj = (MeaningfulPKTest1)objects.get(0);
        Assert.assertEquals((long)0L, (long)obj.getMeaningfulPKDepArray().size());
    }

    @Test
    public void testToManyRelationshipWithMeaningfulPK2() {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setPkAttribute(1000);
        obj.setDescr("aaa-aaa");
        this.context.commitChanges();
        MeaningfulPKDep dep = this.context.newObject(MeaningfulPKDep.class);
        dep.setToMeaningfulPK(obj);
        this.context.commitChanges();
    }

    @Test
    public void testGeneratedIntegerPK() {
        MeaningfulPkTest2 obj1 = this.context.newObject(MeaningfulPkTest2.class);
        obj1.setIntegerAttribute(10);
        MeaningfulPkTest2 obj2 = this.context.newObject(MeaningfulPkTest2.class);
        obj2.setIntegerAttribute(20);
        this.context.commitChanges();
        ObjectContext context = this.runtime.newContext();
        List objects = ObjectSelect.query(MeaningfulPkTest2.class).select(context);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertNotEquals((Object)0, (Object)obj1.getPkAttribute());
        Assert.assertNotEquals((Object)0, (Object)obj2.getPkAttribute());
        Assert.assertNotEquals((Object)obj1.getPkAttribute(), (Object)obj2.getPkAttribute());
    }

    @Test
    public void testMeaningfulIntegerPK() {
        MeaningfulPkTest2 obj1 = this.context.newObject(MeaningfulPkTest2.class);
        obj1.setIntegerAttribute(10);
        obj1.setPkAttribute(1);
        MeaningfulPkTest2 obj2 = this.context.newObject(MeaningfulPkTest2.class);
        obj2.setIntegerAttribute(20);
        obj2.setPkAttribute(2);
        this.context.commitChanges();
        ObjectContext context = this.runtime.newContext();
        List objects = ObjectSelect.query(MeaningfulPkTest2.class).select(context);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertEquals((Object)1, (Object)obj1.getPkAttribute());
        Assert.assertEquals((Object)2, (Object)obj2.getPkAttribute());
    }

    @Test
    public void testGeneratedIntPK() {
        MeaningfulPKTest1 obj1 = this.context.newObject(MeaningfulPKTest1.class);
        obj1.setIntAttribute(10);
        MeaningfulPKTest1 obj2 = this.context.newObject(MeaningfulPKTest1.class);
        obj2.setIntAttribute(20);
        this.context.commitChanges();
        ObjectContext context = this.runtime.newContext();
        List objects = ObjectSelect.query(MeaningfulPKTest1.class).select(context);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertNotEquals((long)0L, (long)obj1.getPkAttribute());
        Assert.assertNotEquals((long)0L, (long)obj2.getPkAttribute());
        Assert.assertNotEquals((long)obj1.getPkAttribute(), (long)obj2.getPkAttribute());
    }

    @Test
    public void testMeaningfulIntPK() {
        MeaningfulPKTest1 obj1 = this.context.newObject(MeaningfulPKTest1.class);
        obj1.setIntAttribute(10);
        obj1.setPkAttribute(1);
        MeaningfulPKTest1 obj2 = this.context.newObject(MeaningfulPKTest1.class);
        obj2.setIntAttribute(20);
        obj2.setPkAttribute(2);
        this.context.commitChanges();
        ObjectContext context = this.runtime.newContext();
        List objects = ObjectSelect.query(MeaningfulPKTest1.class).select(context);
        Assert.assertEquals((long)2L, (long)objects.size());
        Assert.assertEquals((long)1L, (long)obj1.getPkAttribute());
        Assert.assertEquals((long)2L, (long)obj2.getPkAttribute());
    }

    @Test
    @Ignore(value="Insert will fail")
    public void testInsertDelete() {
        MeaningfulPk pkObj = this.context.newObject(MeaningfulPk.class);
        pkObj.setPk("123");
        this.context.commitChanges();
        this.context.deleteObject(pkObj);
        MeaningfulPk pkObj2 = this.context.newObject(MeaningfulPk.class);
        pkObj2.setPk("123");
        this.context.commitChanges();
    }

    @Test
    @Ignore
    public void test_MeaningfulPkInsertDeleteCascade() {
        MeaningfulPKTest1 obj = this.context.newObject(MeaningfulPKTest1.class);
        obj.setPkAttribute(1000);
        obj.setDescr("aaa");
        this.context.commitChanges();
        MeaningfulPKDep dep = this.context.newObject(MeaningfulPKDep.class);
        dep.setToMeaningfulPK(obj);
        dep.setPk(10);
        this.context.commitChanges();
        this.context.deleteObject(obj);
        MeaningfulPKTest1 obj2 = this.context.newObject(MeaningfulPKTest1.class);
        obj2.setPkAttribute(1000);
        obj2.setDescr("bbb");
        MeaningfulPKDep dep2 = this.context.newObject(MeaningfulPKDep.class);
        dep2.setToMeaningfulPK(obj2);
        dep2.setPk(10);
        this.context.commitChanges();
    }

    @Test
    public void testMeaningfulFKToOneInvalidate() {
        MeaningfulPk pk = this.context.newObject(MeaningfulPk.class);
        MeaningfulPkDep2 dep = this.context.newObject(MeaningfulPkDep2.class);
        dep.setMeaningfulPk(pk);
        dep.setDescr("test");
        ObjectContext childContext = this.runtime.newContext(this.context);
        MeaningfulPkDep2 depChild = childContext.localObject(dep);
        depChild.setDescr("test2");
        Assert.assertEquals((Object)"test2", (Object)depChild.getDescr());
        Assert.assertNotNull((Object)depChild.getMeaningfulPk());
        Assert.assertNull((Object)depChild.getMeaningfulPk().getPk());
    }
}

