/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.dba.frontbase.FrontBaseAdapter;
import org.apache.cayenne.dba.openbase.OpenBaseAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CayenneIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"});
    }

    private void createOneArtist() throws Exception {
        this.tArtist.insert(new Object[]{33002, "artist2"});
    }

    private void createTwoArtists() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
    }

    @Test
    public void testReadNestedProperty_ToMany() throws Exception {
        this.tArtist.insert(new Object[]{1, "a"});
        this.tPainting.insert(new Object[]{1, 1, "a1"});
        this.tPainting.insert(new Object[]{2, 1, "a2"});
        Artist a = Cayenne.objectForPK(this.context, Artist.class, 1);
        Collection titles = (Collection)Cayenne.readNestedProperty(a, "paintingArray.paintingTitle");
        Assert.assertEquals((long)2L, (long)titles.size());
        Assert.assertTrue((boolean)titles.contains("a1"));
        Assert.assertTrue((boolean)titles.contains("a2"));
        int size = (Integer)Cayenne.readNestedProperty(a, "paintingArray.@size");
        Assert.assertEquals((long)2L, (long)size);
    }

    @Test
    public void testScalarObjectForQuery() throws Exception {
        this.createTwoArtists();
        String sql = "SELECT count(1) AS X FROM ARTIST";
        DataMap map = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate query = new SQLTemplate(map, sql, false);
        query.setTemplate(FrontBaseAdapter.class.getName(), "SELECT COUNT(ARTIST_ID) AS X FROM ARTIST");
        query.setTemplate(OpenBaseAdapter.class.getName(), "SELECT COUNT(ARTIST_ID) AS X FROM ARTIST");
        query.setColumnNamesCapitalization(CapsStrategy.UPPER);
        SQLResult rsMap = new SQLResult();
        rsMap.addColumnResult("X");
        query.setResult(rsMap);
        Object object = Cayenne.objectForQuery(this.context, query);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Number));
        Assert.assertEquals((long)2L, (long)((Number)object).intValue());
    }

    @Test
    public void testScalarObjectForQuery2() throws Exception {
        this.createTwoArtists();
        String ejbql = "SELECT count(a) from Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        Object object = Cayenne.objectForQuery(this.context, query);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((String)("Object class: " + object.getClass().getName()), (boolean)(object instanceof Number));
        Assert.assertEquals((long)2L, (long)((Number)object).intValue());
    }

    @Test
    public void testMakePath() {
        Assert.assertEquals((Object)"", (Object)Cayenne.makePath(new String[0]));
        Assert.assertEquals((Object)"a", (Object)Cayenne.makePath("a"));
        Assert.assertEquals((Object)"a.b", (Object)Cayenne.makePath("a", "b"));
    }

    @Test
    public void testObjectForQuery() throws Exception {
        this.createOneArtist();
        ObjectId id = ObjectId.of("Artist", "ARTIST_ID", 33002);
        Assert.assertNull((Object)this.context.getGraphManager().getNode(id));
        Object object = Cayenne.objectForQuery(this.context, new ObjectIdQuery(id));
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Artist));
        Assert.assertEquals((Object)"artist2", (Object)((Artist)object).getArtistName());
    }

    @Test
    public void testObjectForSelect() throws Exception {
        this.createOneArtist();
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class, ExpressionFactory.matchDbExp("ARTIST_NAME", "artist2"));
        Artist object = this.context.selectOne(query);
        Assert.assertNotNull((Object)object);
        Assert.assertEquals((Object)"artist2", (Object)object.getArtistName());
    }

    @Test
    public void testObjectForQueryNoObject() throws Exception {
        ObjectId id = ObjectId.of("Artist", "ARTIST_ID", 44001);
        Object object = Cayenne.objectForQuery(this.context, new ObjectIdQuery(id));
        Assert.assertNull((Object)object);
    }

    @Test
    public void testNoObjectForPK() throws Exception {
        this.createOneArtist();
        Artist object = Cayenne.objectForPK(this.context, Artist.class, 44001);
        Assert.assertNull((Object)object);
    }

    @Test
    public void testObjectForPKTemporary() throws Exception {
        Persistent o1 = this.context.newObject(Artist.class);
        Persistent o2 = this.context.newObject(Artist.class);
        Assert.assertSame((Object)o1, (Object)Cayenne.objectForPK(this.context, o1.getObjectId()));
        Assert.assertSame((Object)o2, (Object)Cayenne.objectForPK(this.context, o2.getObjectId()));
        Assert.assertNull((Object)Cayenne.objectForPK(this.context, ObjectId.of("Artist", new byte[]{1, 2, 3})));
    }

    @Test
    public void testObjectForPKObjectId() throws Exception {
        this.createOneArtist();
        Object object = Cayenne.objectForPK(this.context, ObjectId.of("Artist", "ARTIST_ID", 33002));
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Artist));
        Assert.assertEquals((Object)"artist2", (Object)((Artist)object).getArtistName());
    }

    @Test
    public void testObjectForPKClassInt() throws Exception {
        this.createOneArtist();
        Artist object = Cayenne.objectForPK(this.context, Artist.class, 33002);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Artist));
        Assert.assertEquals((Object)"artist2", (Object)object.getArtistName());
    }

    @Test
    public void testObjectForPKEntityInt() throws Exception {
        this.createOneArtist();
        Object object = Cayenne.objectForPK(this.context, "Artist", 33002);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Artist));
        Assert.assertEquals((Object)"artist2", (Object)((Artist)object).getArtistName());
    }

    @Test
    public void testObjectForPKClassMap() throws Exception {
        this.createOneArtist();
        Map<String, Integer> pk = Collections.singletonMap("ARTIST_ID", new Integer(33002));
        Artist object = Cayenne.objectForPK(this.context, Artist.class, pk);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Artist));
        Assert.assertEquals((Object)"artist2", (Object)object.getArtistName());
    }

    @Test
    public void testIntPKForObject() throws Exception {
        this.createOneArtist();
        List objects = ObjectSelect.query(Artist.class).select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
        DataObject object = (DataObject)objects.get(0);
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject(object));
    }

    @Test
    public void testPKForObject() throws Exception {
        this.createOneArtist();
        List objects = ObjectSelect.query(Artist.class).select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
        DataObject object = (DataObject)objects.get(0);
        Assert.assertEquals((Object)33002L, (Object)Cayenne.pkForObject(object));
    }

    @Test
    public void testEjbql() throws Exception {
        this.createOneArtist();
        List objects = this.context.performQuery(new EJBQLQuery("select a from Artist a"));
        Assert.assertEquals((long)1L, (long)objects.size());
        Artist object = (Artist)objects.get(0);
        Assert.assertEquals((Object)33002L, (Object)Cayenne.pkForObject(object));
    }
}

