/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Date;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CDOOne2ManyIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
    }

    @Test
    public void testSelectWithToManyDBQualifier() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("Xyz");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("1");
        a1.addToPaintingArray(p1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("2");
        a1.addToPaintingArray(p2);
        Painting p3 = this.context.newObject(Painting.class);
        p3.setPaintingTitle("3");
        a1.addToPaintingArray(p3);
        this.context.commitChanges();
        Expression e = ExpressionFactory.matchDbExp("paintingArray", p2);
        List artists = ObjectSelect.query(Artist.class, e).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertSame((Object)a1, artists.get(0));
    }

    @Test
    public void testSelectWithToManyQualifier() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("Xyz");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("1");
        a1.addToPaintingArray(p1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("2");
        a1.addToPaintingArray(p2);
        Painting p3 = this.context.newObject(Painting.class);
        p3.setPaintingTitle("3");
        a1.addToPaintingArray(p3);
        this.context.commitChanges();
        Expression e = ExpressionFactory.matchExp("paintingArray", (Object)p2);
        List artists = ObjectSelect.query(Artist.class, e).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertSame((Object)a1, artists.get(0));
    }

    @Test
    public void testNewAdd() throws Exception {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XyzQ");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("1");
        a1.addToPaintingArray(p1);
        Assert.assertSame((Object)p1, (Object)a1.getPaintingArray().get(0));
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        this.context.commitChanges();
        Object[] aRow = this.tArtist.select();
        Assert.assertEquals((Object)"XyzQ", (Object)String.valueOf(aRow[1]).trim());
        Object[] pRow = this.tPainting.select();
        Assert.assertEquals((Object)"1", (Object)pRow[1]);
        Assert.assertEquals((Object)aRow[0], (Object)pRow[2]);
    }

    @Test
    public void testNewAddMultiples() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XyzV");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("1");
        a1.addToPaintingArray(p1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("2");
        a1.addToPaintingArray(p2);
        Assert.assertEquals((long)2L, (long)a1.getPaintingArray().size());
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertSame((Object)a1, (Object)p2.getToArtist());
        this.context.commitChanges();
        ObjectContext context2 = this.runtime.newContext();
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).selectOne(context2);
        Assert.assertEquals((long)2L, (long)a2.getPaintingArray().size());
    }

    @Test
    public void testRemove1() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XyzE");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("1");
        a1.addToPaintingArray(p1);
        this.context.commitChanges();
        ObjectContext context2 = this.runtime.newContext();
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).selectOne(context2);
        Painting p2 = a2.getPaintingArray().get(0);
        a2.removeFromPaintingArray(p2);
        Assert.assertEquals((long)0L, (long)a2.getPaintingArray().size());
        Assert.assertNull((Object)p2.getToGallery());
        context2.commitChanges();
        ObjectContext context3 = this.runtime.newContext();
        Painting p3 = (Painting)ObjectSelect.query(Painting.class).selectOne(context3);
        Assert.assertNull((Object)p3.getToArtist());
        Artist a3 = (Artist)ObjectSelect.query(Artist.class).selectOne(context3);
        Assert.assertEquals((long)0L, (long)a3.getPaintingArray().size());
    }

    @Test
    public void testRemove2() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XyzQ");
        Painting p01 = this.context.newObject(Painting.class);
        p01.setPaintingTitle("1");
        a1.addToPaintingArray(p01);
        Painting p02 = this.context.newObject(Painting.class);
        p02.setPaintingTitle("2");
        a1.addToPaintingArray(p02);
        this.context.commitChanges();
        ObjectContext context2 = this.runtime.newContext();
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).selectOne(context2);
        Assert.assertEquals((long)2L, (long)a2.getPaintingArray().size());
        Painting p2 = a2.getPaintingArray().get(0);
        a2.removeFromPaintingArray(p2);
        Assert.assertEquals((long)1L, (long)a2.getPaintingArray().size());
        Assert.assertNull((Object)p2.getToArtist());
        context2.commitChanges();
        ObjectContext context3 = this.runtime.newContext();
        Artist a3 = (Artist)ObjectSelect.query(Artist.class).selectOne(context3);
        Assert.assertEquals((long)1L, (long)a3.getPaintingArray().size());
    }

    @Test
    public void testPropagatePK() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XyBn");
        Gallery g1 = this.context.newObject(Gallery.class);
        g1.setGalleryName("Tyu");
        Exhibit e1 = this.context.newObject(Exhibit.class);
        e1.setToGallery(g1);
        e1.setOpeningDate(new Date());
        e1.setClosingDate(new Date());
        this.context.commitChanges();
        ArtistExhibit ae1 = this.context.newObject(ArtistExhibit.class);
        e1.addToArtistExhibitArray(ae1);
        a1.addToArtistExhibitArray(ae1);
        Assert.assertSame((Object)e1, (Object)ae1.getToExhibit());
        Assert.assertSame((Object)a1, (Object)ae1.getToArtist());
        this.context.commitChanges();
    }
}

