/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/
package org.apache.cayenne.ejbql;

/**
 * Creates {@link EJBQLParser} based on the system settings.
 * 
 * @since 3.0
 */
public class EJBQLParserFactory {

    // this is the parser generated by JJTree/JavaCC
    private static String DEFAULT_PARSER_CLASS = "org.apache.cayenne.ejbql.parser.EJBQL$EJBQLDefaultParser";

    private static Class parserClass;

    private static Class getParserClass() throws ClassNotFoundException {
        if (parserClass == null) {
            // for now support only the default parser. If needed it should be
            // easy to plug external parsers via a System property...
            parserClass = Class.forName(DEFAULT_PARSER_CLASS, true, Thread
                    .currentThread()
                    .getContextClassLoader());
        }

        return parserClass;
    }

    public static EJBQLParser getParser() throws EJBQLException {
        try {
            return (EJBQLParser) getParserClass().newInstance();
        }
        catch (Exception e) {
            throw new EJBQLException("Error creating EJBQL parser", e);
        }
    }
}
