/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.directive;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ResultDirectiveIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    protected DBHelper dbHelper;

    @Before
    public void before() throws SQLException {
        new TableHelper(this.dbHelper, "ARTIST").setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"}).insert(new Object[]{1L, "ArtistToTestResult"});
    }

    @Test
    public void testWithoutResultDirective() throws Exception {
        String sql = "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST";
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)1L, (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)"ArtistToTestResult", (Object)selectResult.get("ARTIST_NAME"));
    }

    @Test
    public void testWithOnlyResultDirective() throws Exception {
        String sql = "SELECT #result('ARTIST_ID' 'java.lang.Integer'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST";
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)1L, (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)"ArtistToTestResult", (Object)selectResult.get("ARTIST_NAME").toString().trim());
    }

    @Test
    public void testWithMixedDirectiveUse1() throws Exception {
        String sql = "SELECT ARTIST_ID, #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST";
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)1L, (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)"ArtistToTestResult", (Object)selectResult.get("ARTIST_NAME").toString().trim());
    }

    @Test
    public void testWithMixedDirectiveUse2() throws Exception {
        String sql = "SELECT #result('ARTIST_ID' 'java.lang.Integer'), ARTIST_NAME FROM ARTIST";
        Map<String, Object> selectResult = this.selectForQuery(sql);
        Assert.assertEquals((Object)1L, (Object)selectResult.get("ARTIST_ID"));
        Assert.assertEquals((Object)"ArtistToTestResult", (Object)selectResult.get("ARTIST_NAME"));
    }

    private Map<String, Object> selectForQuery(String sql) {
        SQLTemplate template = new SQLTemplate(Artist.class, sql);
        template.setColumnNamesCapitalization(CapsStrategy.UPPER);
        MockOperationObserver observer = new MockOperationObserver();
        this.runtime.getDataDomain().performQueries(Collections.singletonList(template), observer);
        List data = observer.rowsForQuery(template);
        Assert.assertEquals((long)1L, (long)data.size());
        Map row = (Map)data.get(0);
        return row;
    }
}

