/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.XMLEncoder;
import org.junit.Assert;
import org.junit.Test;

public class ObjEntityTest {
    @Test
    public void testEncodeAsXML() {
        ObjEntity entity = new ObjEntity("X");
        entity.setClassName("org.example.Xc");
        entity.addAttribute(new ObjAttribute("a2", "java.lang.String", entity));
        entity.addAttribute(new ObjAttribute("a1", "int", entity));
        entity.addAttribute(new ObjAttribute("a3", "long", entity));
        entity.addRelationship(new ObjRelationship("r1"));
        StringWriter out = new StringWriter();
        XMLEncoder encoder = new XMLEncoder(new PrintWriter(out));
        entity.encodeAsXML(encoder, new EncoderDummyVisitor());
        String ls = System.lineSeparator();
        Assert.assertEquals((Object)("<obj-entity name=\"X\" className=\"org.example.Xc\">" + ls + "<obj-attribute name=\"a1\" type=\"int\"/>" + ls + "<obj-attribute name=\"a2\" type=\"java.lang.String\"/>" + ls + "<obj-attribute name=\"a3\" type=\"long\"/>" + ls + "</obj-entity>" + ls), (Object)out.toString());
    }

    private class EncoderDummyVisitor
    extends BaseConfigurationNodeVisitor<Object> {
        private EncoderDummyVisitor() {
        }

        @Override
        public Object visitObjEntity(ObjEntity entity) {
            return null;
        }

        @Override
        public Object visitObjAttribute(ObjAttribute attribute) {
            return null;
        }

        @Override
        public Object visitObjRelationship(ObjRelationship relationship) {
            return null;
        }
    }
}

