/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import org.apache.cayenne.exp.parser.ASTLess;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ASTLessTest {
    @Test
    public void testEvaluate() {
        ASTLess e = new ASTLess(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        noMatch.setEstimatedPrice(new BigDecimal(10001));
        Assert.assertFalse((String)("Failed: " + e), (boolean)e.match(noMatch));
        Painting noMatch1 = new Painting();
        noMatch1.setEstimatedPrice(new BigDecimal(10000));
        Assert.assertFalse((String)("Failed: " + e), (boolean)e.match(noMatch1));
        Painting match = new Painting();
        match.setEstimatedPrice(new BigDecimal(9999));
        Assert.assertTrue((String)("Failed: " + e), (boolean)e.match(match));
    }

    @Test
    public void testEvaluate_Null() {
        ASTLess ltNull = new ASTLess(new ASTObjPath("estimatedPrice"), null);
        ASTLess ltNotNull = new ASTLess(new ASTObjPath("estimatedPrice"), new BigDecimal(10000.0));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)ltNull.match(noMatch));
        Assert.assertFalse((boolean)ltNotNull.match(noMatch));
    }
}

