/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.exp.parser.ASTAbs;
import org.apache.cayenne.exp.parser.ASTAvg;
import org.apache.cayenne.exp.parser.ASTConcat;
import org.apache.cayenne.exp.parser.ASTCount;
import org.apache.cayenne.exp.parser.ASTDistinct;
import org.apache.cayenne.exp.parser.ASTLength;
import org.apache.cayenne.exp.parser.ASTLocate;
import org.apache.cayenne.exp.parser.ASTLower;
import org.apache.cayenne.exp.parser.ASTMax;
import org.apache.cayenne.exp.parser.ASTMin;
import org.apache.cayenne.exp.parser.ASTMod;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ASTSqrt;
import org.apache.cayenne.exp.parser.ASTSubstring;
import org.apache.cayenne.exp.parser.ASTSum;
import org.apache.cayenne.exp.parser.ASTTrim;
import org.apache.cayenne.exp.parser.ASTUpper;
import org.apache.cayenne.exp.parser.PatternMatchNode;
import org.apache.cayenne.reflect.TstJavaBean;
import org.junit.Assert;
import org.junit.Test;

public class PropertyTest {
    @Test
    public void testPath() {
        Property<String> p = Property.create("x.y", String.class);
        Expression pp = p.path();
        Assert.assertEquals((Object)ExpressionFactory.exp("x.y", new Object[0]), (Object)pp);
    }

    @Test
    public void testIn() {
        Property<String> p = Property.create("x.y", String.class);
        Expression e1 = p.in("a", (String[])new String[0]);
        Assert.assertEquals((Object)"x.y in (\"a\")", (Object)e1.toString());
        Expression e2 = p.in("a", (String[])new String[]{"b"});
        Assert.assertEquals((Object)"x.y in (\"a\", \"b\")", (Object)e2.toString());
        Expression e3 = p.in(Arrays.asList("a", "b"));
        Assert.assertEquals((Object)"x.y in (\"a\", \"b\")", (Object)e3.toString());
    }

    @Test
    public void testGetFrom() {
        TstJavaBean bean = new TstJavaBean();
        bean.setIntField(7);
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        Assert.assertEquals((Object)7, (Object)INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromNestedProperty() {
        TstJavaBean bean = new TstJavaBean();
        TstJavaBean nestedBean = new TstJavaBean();
        nestedBean.setIntField(7);
        bean.setObjectField(nestedBean);
        Property<Integer> OBJECT_FIELD_INT_FIELD = Property.create("objectField.intField", Integer.class);
        Assert.assertEquals((Object)7, (Object)OBJECT_FIELD_INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromNestedNull() {
        TstJavaBean bean = new TstJavaBean();
        bean.setObjectField(null);
        Property<Integer> OBJECT_FIELD_INT_FIELD = Property.create("objectField.intField", Integer.class);
        Assert.assertNull((Object)OBJECT_FIELD_INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromAll() {
        TstJavaBean bean = new TstJavaBean();
        bean.setIntField(7);
        TstJavaBean bean2 = new TstJavaBean();
        bean2.setIntField(8);
        List<TstJavaBean> beans = Arrays.asList(bean, bean2);
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        Assert.assertEquals(Arrays.asList(7, 8), INT_FIELD.getFromAll(beans));
    }

    @Test
    public void testSetIn() {
        TstJavaBean bean = new TstJavaBean();
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        INT_FIELD.setIn(bean, 7);
        Assert.assertEquals((long)7L, (long)bean.getIntField());
    }

    @Test
    public void testSetInNestedProperty() {
        TstJavaBean bean = new TstJavaBean();
        bean.setObjectField(new TstJavaBean());
        Property<Integer> OBJECT_FIELD_INT_FIELD = Property.create("objectField.intField", Integer.class);
        OBJECT_FIELD_INT_FIELD.setIn(bean, 7);
        Assert.assertEquals((long)7L, (long)((TstJavaBean)bean.getObjectField()).getIntField());
    }

    @Test
    public void testSetInNestedNull() {
        TstJavaBean bean = new TstJavaBean();
        bean.setObjectField(null);
        Property<Integer> OBJECT_FIELD_INT_FIELD = Property.create("objectField.intField", Integer.class);
        OBJECT_FIELD_INT_FIELD.setIn(bean, 7);
    }

    @Test
    public void testSetInAll() {
        TstJavaBean bean = new TstJavaBean();
        TstJavaBean bean2 = new TstJavaBean();
        List<TstJavaBean> beans = Arrays.asList(bean, bean2);
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        INT_FIELD.setInAll(beans, 7);
        Assert.assertEquals((long)7L, (long)bean.getIntField());
        Assert.assertEquals((long)7L, (long)bean2.getIntField());
    }

    @Test
    public void testEqualsWithName() {
        Property<Integer> INT_FIELD2;
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        Assert.assertTrue((INT_FIELD != (INT_FIELD2 = Property.create("intField", Integer.class)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)INT_FIELD.equals(INT_FIELD2));
    }

    @Test
    public void testHashCodeWithName() {
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        Property<Integer> INT_FIELD2 = Property.create("intField", Integer.class);
        Property<Long> LONG_FIELD = Property.create("longField", Long.class);
        Assert.assertTrue((INT_FIELD.hashCode() == INT_FIELD2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((INT_FIELD.hashCode() != LONG_FIELD.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithNameAndType() {
        Property<Integer> INT_FIELD2;
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        Assert.assertTrue((INT_FIELD != (INT_FIELD2 = Property.create("intField", Integer.class)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)INT_FIELD.equals(INT_FIELD2));
    }

    @Test
    public void testHashCodeWithNameAndType() {
        Property<Integer> INT_FIELD = Property.create("intField", Integer.class);
        Property<Integer> INT_FIELD2 = Property.create("intField", Integer.class);
        Property<Long> LONG_FIELD = Property.create("longField", Long.class);
        Assert.assertTrue((INT_FIELD.hashCode() == INT_FIELD2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((INT_FIELD.hashCode() != LONG_FIELD.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithExpAndType() {
        Property<Integer> INT_FIELD2;
        Property<Integer> INT_FIELD = new Property<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class);
        Assert.assertTrue((INT_FIELD != (INT_FIELD2 = new Property<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class)) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)INT_FIELD.equals(INT_FIELD2));
    }

    @Test
    public void testHashCodeWithExpAndType() {
        Property<Integer> INT_FIELD = new Property<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class);
        Property<Integer> INT_FIELD2 = new Property<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class);
        Property<Integer> INT_FIELD3 = new Property<Integer>(null, ExpressionFactory.exp("2", new Object[0]), Integer.class);
        Assert.assertEquals((long)INT_FIELD.hashCode(), (long)INT_FIELD2.hashCode());
        Assert.assertNotEquals((long)INT_FIELD.hashCode(), (long)INT_FIELD3.hashCode());
    }

    @Test
    public void testOuter() {
        Property<String> inner = Property.create("xyz", String.class);
        Assert.assertEquals((Object)"xyz+", (Object)inner.outer().getName());
        Property<String> inner1 = Property.create("xyz.xxx", String.class);
        Assert.assertEquals((Object)"xyz.xxx+", (Object)inner1.outer().getName());
        Property<String> outer = Property.create("xyz+", String.class);
        Assert.assertEquals((Object)"xyz+", (Object)outer.outer().getName());
    }

    @Test
    public void testLike() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.like("abc");
        Assert.assertEquals((Object)"prop like \"abc\"", (Object)e.toString());
    }

    @Test
    public void testLikeIgnoreCase() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.likeIgnoreCase("abc");
        Assert.assertEquals((Object)"prop likeIgnoreCase \"abc\"", (Object)e.toString());
    }

    @Test
    public void testLike_NoEscape() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.like("ab%c");
        Assert.assertEquals((Object)"prop like \"ab%c\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testContains() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.contains("abc");
        Assert.assertEquals((Object)"prop like \"%abc%\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testStartsWith() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.startsWith("abc");
        Assert.assertEquals((Object)"prop like \"abc%\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testEndsWith() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.endsWith("abc");
        Assert.assertEquals((Object)"prop like \"%abc\"", (Object)e.toString());
        Assert.assertEquals((long)0L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testContains_Escape1() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.contains("a%bc");
        Assert.assertEquals((Object)"prop like \"%a!%bc%\"", (Object)e.toString());
        Assert.assertEquals((long)33L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testContains_Escape2() {
        Property<String> p = Property.create("prop", String.class);
        Expression e = p.contains("a_!bc");
        Assert.assertEquals((Object)"prop like \"%a#_!bc%\"", (Object)e.toString());
        Assert.assertEquals((long)35L, (long)((PatternMatchNode)e).getEscapeChar());
    }

    @Test
    public void testExpressionConstructor() {
        Property<Integer> p = Property.create("testPath", new ASTObjPath("test.path"), Integer.class);
        Assert.assertEquals((Object)"testPath", (Object)p.getName());
        Expression ex = p.getExpression();
        Assert.assertEquals((Object)"test.path", (Object)ex.toString());
    }

    @Test
    public void testCreationWithName() {
        Property<String> p1 = new Property<String>("p1", String.class);
        Assert.assertEquals(String.class, p1.getType());
        Assert.assertEquals((Object)"p1", (Object)p1.getName());
        Assert.assertEquals((Object)new ASTObjPath("p1"), (Object)p1.getExpression());
        Property<String> p2 = Property.create("p1", String.class);
        Assert.assertEquals(p1, p2);
    }

    @Test
    public void testCreationWithExp() {
        Expression exp = FunctionExpressionFactory.currentTime();
        Property<String> p1 = new Property<String>(null, exp, String.class);
        Assert.assertEquals(String.class, p1.getType());
        Assert.assertEquals(null, (Object)p1.getName());
        Assert.assertEquals((Object)exp, (Object)p1.getExpression());
        Property<String> p2 = Property.create(exp, String.class);
        Assert.assertEquals(p1, p2);
    }

    @Test
    public void testCreationWithNameAndExp() {
        Expression exp = FunctionExpressionFactory.currentTime();
        Property<String> p1 = new Property<String>("p1", exp, String.class);
        Assert.assertEquals(String.class, p1.getType());
        Assert.assertEquals((Object)"p1", (Object)p1.getName());
        Assert.assertEquals((Object)exp, (Object)p1.getExpression());
        Property<String> p2 = Property.create("p1", exp, String.class);
        Assert.assertEquals(p1, p2);
    }

    @Test
    public void testAlias() {
        Expression exp = FunctionExpressionFactory.currentTime();
        Property<String> p1 = new Property<String>("p1", exp, String.class);
        Assert.assertEquals(String.class, p1.getType());
        Assert.assertEquals((Object)"p1", (Object)p1.getName());
        Assert.assertEquals((Object)exp, (Object)p1.getExpression());
        Property<String> p2 = p1.alias("p2");
        Assert.assertEquals(String.class, p2.getType());
        Assert.assertEquals((Object)"p2", (Object)p2.getName());
        Assert.assertEquals((Object)exp, (Object)p2.getExpression());
    }

    @Test
    public void testCount() {
        Property<String> p = Property.create("test", String.class);
        Property<Long> newProp = p.count();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTCount));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testCountDistinct() {
        Property<String> p = Property.create("test", String.class);
        Property<Long> newProp = p.countDistinct();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTCount));
        Assert.assertTrue((boolean)(newProp.getExpression().getOperand(0) instanceof ASTDistinct));
        Assert.assertEquals((Object)p.getExpression(), (Object)((ASTDistinct)newProp.getExpression().getOperand(0)).getOperand(0));
    }

    @Test
    public void testMin() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.min();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTMin));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testMax() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.max();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTMax));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testSum() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.sum();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTSum));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testAvg() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.avg();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTAvg));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testAbs() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.abs();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTAbs));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testMod() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.mod(3.0);
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTMod));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
        Assert.assertEquals((Object)3.0, (Object)newProp.getExpression().getOperand(1));
    }

    @Test
    public void testSqrt() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.sqrt();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTSqrt));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testLength() {
        Property<String> p = Property.create("test", String.class);
        Property<Integer> newProp = p.length();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTLength));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testLocateString() {
        Property<String> p = Property.create("test", String.class);
        Property<Integer> newProp = p.locate("test");
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTLocate));
        Assert.assertEquals((Object)"test", (Object)newProp.getExpression().getOperand(0));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(1));
    }

    @Test
    public void testLocateProperty() {
        Property<String> p = Property.create("test", String.class);
        Property<String> p2 = Property.create("test2", String.class);
        Property<Integer> newProp = p.locate(p2);
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTLocate));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(1));
        Assert.assertEquals((Object)p2.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testSustring() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.substring(1, 2);
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTSubstring));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
        Assert.assertEquals((Object)1, (Object)newProp.getExpression().getOperand(1));
        Assert.assertEquals((Object)2, (Object)newProp.getExpression().getOperand(2));
    }

    @Test
    public void testTrim() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.trim();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTTrim));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testLower() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.lower();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTLower));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testUpper() {
        Property<String> p = Property.create("test", String.class);
        Property<String> newProp = p.upper();
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTUpper));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
    }

    @Test
    public void testConcat() {
        Property<String> p = Property.create("test", String.class);
        Property<String> p2 = Property.create("concat", String.class);
        ASTScalar exp = new ASTScalar((Object)3);
        Property<String> newProp = p.concat("string", exp, p2);
        Assert.assertTrue((boolean)(newProp.getExpression() instanceof ASTConcat));
        Assert.assertEquals((Object)p.getExpression(), (Object)newProp.getExpression().getOperand(0));
        Assert.assertEquals((Object)"string", (Object)newProp.getExpression().getOperand(1));
        Assert.assertEquals((Object)3, (Object)newProp.getExpression().getOperand(2));
        Assert.assertEquals((Object)p2.getExpression(), (Object)newProp.getExpression().getOperand(3));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testMixDbAndObjPath() {
        Property<Integer> dbPathProperty = Property.create(ExpressionFactory.dbPathExp("db_path"), Integer.class);
        Property<String> objPathProperty = Property.create(ExpressionFactory.pathExp("obj_path"), String.class);
        objPathProperty.dot(dbPathProperty);
    }
}

