/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.BaseHandlerTest;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.ObjEntityHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.junit.Assert;
import org.junit.Test;

public class ObjEntityHandlerTest
extends BaseHandlerTest {
    @Test
    public void testLoad() throws Exception {
        final DataMap map = new DataMap();
        Assert.assertEquals((long)0L, (long)map.getObjEntities().size());
        this.parse("obj-entity", new BaseHandlerTest.HandlerFactory(){

            @Override
            public NamespaceAwareNestedTagHandler createHandler(NamespaceAwareNestedTagHandler parent) {
                return new ObjEntityHandler(parent, map);
            }
        });
        Assert.assertEquals((long)1L, (long)map.getObjEntities().size());
        ObjEntity entity = map.getObjEntity("ArtistCallback");
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)entity.isAbstract());
        Assert.assertTrue((boolean)entity.isReadOnly());
        Assert.assertTrue((boolean)entity.isServerOnly());
        Assert.assertFalse((boolean)entity.isClientAllowed());
        Assert.assertEquals((long)3L, (long)entity.getAttributes().size());
        Assert.assertEquals((long)8L, (long)entity.getCallbackMethods().size());
        Assert.assertEquals((long)1L, (long)entity.getDeclaredLockType());
        Assert.assertEquals((Object)"org.apache.cayenne.testdo.testmap.ArtistCallback", (Object)entity.getClassName());
        Assert.assertNull((String)"super.class should be suppressed by super entity", (Object)entity.getSuperClassName());
        Assert.assertEquals((Object)"Artist", (Object)entity.getSuperEntityName());
        Assert.assertEquals((Object)"client.class", (Object)entity.getClientClassName());
        Assert.assertNull((String)"client.super.class should be suppressed by super entity", (Object)entity.getClientSuperClassName());
        Assert.assertEquals((Object)"ARTIST_CT", (Object)entity.getDbEntityName());
        ObjAttribute attribute = entity.getAttribute("artistName");
        Assert.assertNotNull((Object)attribute);
        Assert.assertEquals((Object)"NAME", (Object)attribute.getDbAttributeName());
        Assert.assertEquals((Object)"java.lang.String", (Object)attribute.getType());
        Assert.assertTrue((boolean)attribute.isUsedForLocking());
        attribute = entity.getAttribute("dateOfBirth");
        Assert.assertNotNull((Object)attribute);
        Assert.assertNull((Object)attribute.getDbAttributeName());
        Assert.assertEquals((Object)"java.util.Date", (Object)attribute.getType());
        Assert.assertFalse((boolean)attribute.isUsedForLocking());
        attribute = entity.getAttribute("embeddable1");
        Assert.assertNotNull((Object)attribute);
        Assert.assertNull((Object)attribute.getDbAttributeName());
        Assert.assertEquals((Object)"org.apache.cayenne.testdo.embeddable.Embeddable1", (Object)attribute.getType());
        Assert.assertFalse((boolean)attribute.isUsedForLocking());
        String override = entity.getDeclaredAttributeOverrides().get("name");
        Assert.assertEquals((Object)"parent.child.name", (Object)override);
    }
}

