/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.unit.util.SQLTemplateCustomizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SQLTemplateActionIT
extends ServerCase {
    @Inject
    protected ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    protected DataNode node;
    @Inject
    protected JdbcAdapter adapter;
    @Inject
    protected UnitDbAdapter unitDbAdapter;
    @Inject
    protected ObjectContext objectContext;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected SQLTemplateCustomizer sqlTemplateCustomizer;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
    }

    protected void createFourArtists() throws Exception {
        Date date = new Date(System.currentTimeMillis());
        this.tArtist.insert(new Object[]{11, "artist2", date});
        this.tArtist.insert(new Object[]{101, "artist3", date});
        this.tArtist.insert(new Object[]{201, "artist4", date});
        this.tArtist.insert(new Object[]{3001, "artist5", date});
    }

    @Test
    public void testProperties() throws Exception {
        SQLTemplate template = new SQLTemplate(Object.class, "AAAAA");
        SQLTemplateAction action = new SQLTemplateAction(template, this.node);
        Assert.assertSame((Object)template, (Object)action.getQuery());
        Assert.assertSame((Object)this.node, (Object)action.dataNode);
    }

    @Test
    public void testExecuteSelect() throws Exception {
        this.createFourArtists();
        String templateString = "SELECT * FROM ARTIST WHERE ARTIST_ID = #bind($id)";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        this.sqlTemplateCustomizer.updateSQLTemplate(template);
        HashMap<String, Long> bindings = new HashMap<String, Long>();
        bindings.put("id", 201L);
        template.setParameters(bindings);
        SQLAction plan = this.adapter.getAction(template, this.node);
        Assert.assertTrue((boolean)(plan instanceof SQLTemplateAction));
        MockOperationObserver observer = new MockOperationObserver();
        try (Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();){
            plan.performAction(c, observer);
        }
        List rows = observer.rowsForQuery(template);
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)1L, (long)rows.size());
        DataRow row = (DataRow)rows.get(0);
        Number id = (Number)row.get("ARTIST_ID");
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((long)((Number)bindings.get("id")).longValue(), (long)id.longValue());
        Assert.assertEquals((Object)"artist4", row.get("ARTIST_NAME"));
        Assert.assertTrue((boolean)row.containsKey("DATE_OF_BIRTH"));
    }

    @Test
    public void selectObjects() throws Exception {
        this.createFourArtists();
        String templateString = "SELECT * FROM ARTIST";
        SQLTemplate sqlTemplate = new SQLTemplate(Artist.class, templateString);
        if (this.unitDbAdapter.isLowerCaseNames()) {
            sqlTemplate.setColumnNamesCapitalization(CapsStrategy.UPPER);
        }
        List artists = this.objectContext.performQuery(sqlTemplate);
        Assert.assertEquals((long)4L, (long)artists.size());
        for (Artist artist : artists) {
            Assert.assertTrue((boolean)artist.getArtistName().startsWith("artist"));
        }
    }

    @Test
    public void testSelectUtilDate() throws Exception {
        this.createFourArtists();
        String templateString = "SELECT #result('DATE_OF_BIRTH' 'java.util.Date' 'DOB') FROM ARTIST WHERE ARTIST_ID = #bind($id)";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        this.sqlTemplateCustomizer.updateSQLTemplate(template);
        HashMap<String, Integer> bindings = new HashMap<String, Integer>();
        bindings.put("id", 101);
        template.setParameters(bindings);
        SQLAction plan = this.adapter.getAction(template, this.node);
        MockOperationObserver observer = new MockOperationObserver();
        try (Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();){
            plan.performAction(c, observer);
        }
        List rows = observer.rowsForQuery(template);
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)1L, (long)rows.size());
        DataRow row = (DataRow)rows.get(0);
        Assert.assertNotNull(row.get("DOB"));
        Assert.assertEquals(java.util.Date.class, row.get("DOB").getClass());
    }

    @Test
    public void testSelectSQLDate() throws Exception {
        this.createFourArtists();
        String templateString = "SELECT #result('DATE_OF_BIRTH' 'java.sql.Date' 'DOB') FROM ARTIST WHERE ARTIST_ID = #bind($id)";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        this.sqlTemplateCustomizer.updateSQLTemplate(template);
        HashMap<String, Integer> bindings = new HashMap<String, Integer>();
        bindings.put("id", 101);
        template.setParameters(bindings);
        SQLAction plan = this.adapter.getAction(template, this.node);
        MockOperationObserver observer = new MockOperationObserver();
        try (Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();){
            plan.performAction(c, observer);
        }
        List rows = observer.rowsForQuery(template);
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)1L, (long)rows.size());
        DataRow row = (DataRow)rows.get(0);
        Assert.assertNotNull(row.get("DOB"));
        Assert.assertEquals(Date.class, row.get("DOB").getClass());
    }

    @Test
    public void testSelectSQLTimestamp() throws Exception {
        this.createFourArtists();
        String templateString = "SELECT #result('DATE_OF_BIRTH' 'java.sql.Timestamp' 'DOB') FROM ARTIST WHERE ARTIST_ID = #bind($id)";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        this.sqlTemplateCustomizer.updateSQLTemplate(template);
        HashMap<String, Integer> bindings = new HashMap<String, Integer>();
        bindings.put("id", 201);
        template.setParameters(bindings);
        SQLAction plan = this.adapter.getAction(template, this.node);
        MockOperationObserver observer = new MockOperationObserver();
        try (Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();){
            plan.performAction(c, observer);
        }
        List rows = observer.rowsForQuery(template);
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)1L, (long)rows.size());
        DataRow row = (DataRow)rows.get(0);
        Assert.assertNotNull(row.get("DOB"));
        Assert.assertTrue((boolean)Timestamp.class.isAssignableFrom(row.get("DOB").getClass()));
    }

    @Test
    public void testExecuteUpdate() throws Exception {
        String templateString = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob 'DATE'))";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("id", new Long(1L));
        bindings.put("name", "a1");
        bindings.put("dob", new Date(System.currentTimeMillis()));
        template.setParameters(bindings);
        SQLAction action = this.adapter.getAction(template, this.node);
        try (Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();){
            MockOperationObserver observer = new MockOperationObserver();
            action.performAction(c, observer);
            int[] batches = observer.countsForQuery(template);
            Assert.assertNotNull((Object)batches);
            Assert.assertEquals((long)1L, (long)batches.length);
            Assert.assertEquals((long)1L, (long)batches[0]);
        }
        Assert.assertEquals((long)1L, (long)this.tArtist.getRowCount());
        Assert.assertEquals((long)1L, (long)this.tArtist.getLong("ARTIST_ID"));
        Assert.assertEquals((Object)"a1", (Object)this.tArtist.getString("ARTIST_NAME").trim());
    }

    @Test
    public void testExecuteUpdateNoParameters() throws Exception {
        this.createFourArtists();
        SQLTemplate template = new SQLTemplate(Object.class, "delete from ARTIST where ARTIST_NAME like 'a%'");
        SQLAction action = this.adapter.getAction(template, this.node);
        try (Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();){
            MockOperationObserver observer = new MockOperationObserver();
            action.performAction(c, observer);
            int[] batches = observer.countsForQuery(template);
            Assert.assertNotNull((Object)batches);
            Assert.assertEquals((long)1L, (long)batches.length);
            Assert.assertEquals((long)4L, (long)batches[0]);
        }
    }

    @Test
    public void testExecuteUpdateBatch() throws Exception {
        String templateString = "INSERT INTO ARTIST (ARTIST_ID, ARTIST_NAME, DATE_OF_BIRTH) VALUES (#bind($id), #bind($name), #bind($dob 'DATE'))";
        SQLTemplate template = new SQLTemplate(Object.class, templateString);
        HashMap<String, Object> bindings1 = new HashMap<String, Object>();
        bindings1.put("id", new Long(1L));
        bindings1.put("name", "a1");
        bindings1.put("dob", new Date(System.currentTimeMillis()));
        HashMap<String, Object> bindings2 = new HashMap<String, Object>();
        bindings2.put("id", new Long(33L));
        bindings2.put("name", "a$$$$$");
        bindings2.put("dob", new Date(System.currentTimeMillis()));
        template.setParameters(bindings1, bindings2);
        SQLAction genericAction = this.adapter.getAction(template, this.node);
        Assert.assertTrue((boolean)(genericAction instanceof SQLTemplateAction));
        SQLTemplateAction action = (SQLTemplateAction)genericAction;
        Assert.assertSame((Object)this.node, (Object)action.dataNode);
        Assert.assertSame((Object)template, (Object)action.getQuery());
        try (Connection c = this.dataSourceFactory.getSharedDataSource().getConnection();){
            MockOperationObserver observer = new MockOperationObserver();
            action.performAction(c, observer);
            int[] batches = observer.countsForQuery(template);
            Assert.assertNotNull((Object)batches);
            Assert.assertEquals((long)2L, (long)batches.length);
            Assert.assertEquals((long)1L, (long)batches[0]);
            Assert.assertEquals((long)1L, (long)batches[1]);
        }
        MockOperationObserver observer = new MockOperationObserver();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        this.node.performQueries(Collections.singletonList(query), observer);
        List data = observer.rowsForQuery(query);
        Assert.assertEquals((long)2L, (long)data.size());
        DataRow row1 = (DataRow)data.get(0);
        Assert.assertEquals(bindings1.get("id"), row1.get("ARTIST_ID"));
        Assert.assertEquals(bindings1.get("name"), row1.get("ARTIST_NAME"));
        DataRow row2 = (DataRow)data.get(1);
        Assert.assertEquals(bindings2.get("id"), row2.get("ARTIST_ID"));
        Assert.assertEquals(bindings2.get("name"), row2.get("ARTIST_NAME"));
    }

    @Test
    public void testExtractTemplateString() throws Exception {
        SQLTemplate template = new SQLTemplate(Artist.class, "A\nBC");
        SQLTemplateAction action = new SQLTemplateAction(template, this.node);
        Assert.assertEquals((Object)"A BC", (Object)action.extractTemplateString());
    }
}

