/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCaseContextsSync;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class NestedDataContextPeerEventsIT
extends ServerCaseContextsSync {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testPeerObjectUpdatedTempOID() throws Exception {
        ObjectContext peer1 = this.runtime.newContext(this.context);
        final Artist a1 = peer1.newObject(Artist.class);
        a1.setArtistName("Y");
        ObjectId a1TempId = a1.getObjectId();
        Assert.assertTrue((boolean)a1TempId.isTemporary());
        ObjectContext peer2 = this.runtime.newContext(this.context);
        final Artist a2 = peer2.localObject(a1);
        Assert.assertEquals((Object)a1TempId, (Object)a2.getObjectId());
        peer1.commitChanges();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertFalse((boolean)a1.getObjectId().isTemporary());
                Assert.assertFalse((boolean)a2.getObjectId().isTemporary());
                Assert.assertEquals((Object)a2.getObjectId(), (Object)a1.getObjectId());
            }
        }.runTest(2000L);
    }

    @Test
    public void testPeerObjectUpdatedSimpleProperty() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        this.context.commitChanges();
        ObjectContext peer1 = this.runtime.newContext(this.context);
        Artist a1 = peer1.localObject(a);
        final ObjectContext peer2 = this.runtime.newContext(this.context);
        final Artist a2 = peer2.localObject(a);
        a1.setArtistName("Y");
        Assert.assertEquals((Object)"X", (Object)a2.getArtistName());
        peer1.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((Object)"Y", (Object)a2.getArtistName());
                Assert.assertFalse((String)"Peer data context became dirty on event processing", (boolean)peer2.hasChanges());
            }
        }.runTest(2000L);
    }

    @Test
    public void testPeerObjectUpdatedToOneRelationship() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        Artist altA = this.context.newObject(Artist.class);
        Painting p = this.context.newObject(Painting.class);
        p.setToArtist(a);
        p.setPaintingTitle("PPP");
        a.setArtistName("X");
        altA.setArtistName("Y");
        this.context.commitChanges();
        ObjectContext peer1 = this.runtime.newContext(this.context);
        Painting p1 = peer1.localObject(p);
        Artist altA1 = peer1.localObject(altA);
        final ObjectContext peer2 = this.runtime.newContext(this.context);
        final Painting p2 = peer2.localObject(p);
        final Artist altA2 = peer2.localObject(altA);
        Artist a2 = peer2.localObject(a);
        p1.setToArtist(altA1);
        Assert.assertSame((Object)a2, (Object)p2.getToArtist());
        peer1.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((Object)altA2, (Object)p2.getToArtist());
                Assert.assertFalse((String)"Peer data context became dirty on event processing", (boolean)peer2.hasChanges());
            }
        }.runTest(2000L);
    }

    @Test
    public void testPeerObjectUpdatedToManyRelationship() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        Painting px = this.context.newObject(Painting.class);
        px.setToArtist(a);
        px.setPaintingTitle("PX");
        Painting py = this.context.newObject(Painting.class);
        py.setPaintingTitle("PY");
        this.context.commitChanges();
        Thread.sleep(500L);
        ObjectContext peer1 = this.runtime.newContext(this.context);
        Painting py1 = peer1.localObject(py);
        Artist a1 = peer1.localObject(a);
        final ObjectContext peer2 = this.runtime.newContext(this.context);
        final Painting py2 = peer2.localObject(py);
        final Artist a2 = peer2.localObject(a);
        a1.addToPaintingArray(py1);
        Assert.assertEquals((long)1L, (long)a2.getPaintingArray().size());
        Assert.assertFalse((boolean)a2.getPaintingArray().contains(py2));
        peer1.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)2L, (long)a2.getPaintingArray().size());
                Assert.assertTrue((boolean)a2.getPaintingArray().contains(py2));
                Assert.assertFalse((String)"Peer data context became dirty on event processing", (boolean)peer2.hasChanges());
            }
        }.runTest(2000L);
    }
}

