/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.map_to_many.IdMapToMany;
import org.apache.cayenne.testdo.map_to_many.IdMapToManyTarget;
import org.apache.cayenne.testdo.map_to_many.MapToMany;
import org.apache.cayenne.testdo.map_to_many.MapToManyTarget;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-map-to-many.xml")
public class CDOMapRelationshipIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tMapToMany;
    protected TableHelper tMapToManyTarget;
    protected TableHelper tIdMapToMany;
    protected TableHelper tIdMapToManyTarget;

    @Before
    public void setUp() throws Exception {
        this.tMapToMany = new TableHelper(this.dbHelper, "MAP_TO_MANY");
        this.tMapToMany.setColumns(new String[]{"ID"});
        this.tMapToManyTarget = new TableHelper(this.dbHelper, "MAP_TO_MANY_TARGET");
        this.tMapToManyTarget.setColumns(new String[]{"ID", "MAP_TO_MANY_ID", "NAME"});
        this.tIdMapToMany = new TableHelper(this.dbHelper, "ID_MAP_TO_MANY");
        this.tIdMapToMany.setColumns(new String[]{"ID"});
        this.tIdMapToManyTarget = new TableHelper(this.dbHelper, "ID_MAP_TO_MANY_TARGET");
        this.tIdMapToManyTarget.setColumns(new String[]{"ID", "MAP_TO_MANY_ID"});
    }

    protected void createTestDataSet() throws Exception {
        this.tMapToMany.insert(new Object[]{1});
        this.tMapToMany.insert(new Object[]{2});
        this.tMapToManyTarget.insert(new Object[]{1, 1, "A"});
        this.tMapToManyTarget.insert(new Object[]{2, 1, "B"});
        this.tMapToManyTarget.insert(new Object[]{3, 1, "C"});
        this.tMapToManyTarget.insert(new Object[]{4, 2, "A"});
    }

    protected void createTestIdDataSet() throws Exception {
        this.tIdMapToMany.insert(new Object[]{1});
        this.tIdMapToMany.insert(new Object[]{2});
        this.tIdMapToManyTarget.insert(new Object[]{1, 1});
        this.tIdMapToManyTarget.insert(new Object[]{2, 1});
        this.tIdMapToManyTarget.insert(new Object[]{3, 1});
        this.tIdMapToManyTarget.insert(new Object[]{4, 2});
    }

    @Test
    public void testReadToMany() throws Exception {
        this.createTestDataSet();
        MapToMany o1 = Cayenne.objectForPK(this.context, MapToMany.class, 1);
        Map<String, MapToManyTarget> targets = o1.getTargets();
        Assert.assertTrue((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertNotNull((Object)targets.get("A"));
        Assert.assertNotNull((Object)targets.get("B"));
        Assert.assertNotNull((Object)targets.get("C"));
        Assert.assertEquals((long)1L, (long)Cayenne.intPKForObject(targets.get("A")));
        Assert.assertEquals((long)2L, (long)Cayenne.intPKForObject(targets.get("B")));
        Assert.assertEquals((long)3L, (long)Cayenne.intPKForObject(targets.get("C")));
    }

    @Test
    public void testReadToManyId() throws Exception {
        this.createTestIdDataSet();
        IdMapToMany o1 = Cayenne.objectForPK(this.context, IdMapToMany.class, 1);
        Map<Object, IdMapToManyTarget> targets = o1.getTargets();
        Assert.assertTrue((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertNotNull((Object)targets.get(new Integer(1)));
        Assert.assertNotNull((Object)targets.get(new Integer(2)));
        Assert.assertNotNull((Object)targets.get(new Integer(3)));
        Assert.assertEquals((long)1L, (long)Cayenne.intPKForObject(targets.get(new Integer(1))));
        Assert.assertEquals((long)2L, (long)Cayenne.intPKForObject(targets.get(new Integer(2))));
        Assert.assertEquals((long)3L, (long)Cayenne.intPKForObject(targets.get(new Integer(3))));
    }

    @Test
    public void testReadToManyPrefetching() throws Exception {
        this.createTestDataSet();
        SelectQuery<MapToMany> query = new SelectQuery<MapToMany>(MapToMany.class, ExpressionFactory.matchDbExp("ID", new Integer(1)));
        query.addPrefetch(MapToMany.TARGETS.disjoint());
        MapToMany o1 = (MapToMany)Cayenne.objectForQuery(this.context, query);
        Map<String, MapToManyTarget> targets = o1.getTargets();
        Assert.assertFalse((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertNotNull((Object)targets.get("A"));
        Assert.assertNotNull((Object)targets.get("B"));
        Assert.assertNotNull((Object)targets.get("C"));
    }

    @Test
    public void testAddToMany() throws Exception {
        this.createTestDataSet();
        MapToMany o1 = Cayenne.objectForPK(this.context, MapToMany.class, 1);
        Map<String, MapToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        MapToManyTarget newTarget = o1.getObjectContext().newObject(MapToManyTarget.class);
        newTarget.setName("X");
        o1.addToTargets(newTarget);
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertSame((Object)newTarget, (Object)o1.getTargets().get("X"));
        Assert.assertSame((Object)o1, (Object)newTarget.getMapToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)4L, (long)o1.getTargets().size());
    }

    @Test
    public void testRemoveToMany() throws Exception {
        this.createTestDataSet();
        MapToMany o1 = Cayenne.objectForPK(this.context, MapToMany.class, 1);
        Map<String, MapToManyTarget> targets = o1.getTargets();
        Assert.assertEquals((long)3L, (long)targets.size());
        MapToManyTarget target = targets.get("B");
        o1.removeFromTargets(target);
        Assert.assertEquals((long)2L, (long)targets.size());
        Assert.assertNull((Object)o1.getTargets().get("B"));
        Assert.assertNull((Object)target.getMapToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)2L, (long)o1.getTargets().size());
        Assert.assertNotNull((Object)o1.getTargets().get("A"));
        Assert.assertNotNull((Object)o1.getTargets().get("C"));
    }

    @Test
    public void testAddToManyViaReverse() throws Exception {
        this.createTestDataSet();
        MapToMany o1 = Cayenne.objectForPK(this.context, MapToMany.class, 1);
        Map<String, MapToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        MapToManyTarget newTarget = o1.getObjectContext().newObject(MapToManyTarget.class);
        newTarget.setName("X");
        newTarget.setMapToMany(o1);
        Assert.assertSame((Object)o1, (Object)newTarget.getMapToMany());
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertSame((Object)newTarget, (Object)o1.getTargets().get("X"));
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)4L, (long)o1.getTargets().size());
    }

    @Test
    public void testModifyToManyKey() throws Exception {
        this.createTestDataSet();
        MapToMany o1 = Cayenne.objectForPK(this.context, MapToMany.class, 1);
        Map<String, MapToManyTarget> targets = o1.getTargets();
        MapToManyTarget target = targets.get("B");
        target.setName("B1");
        o1.getObjectContext().commitChanges();
        Assert.assertNull((Object)o1.getTargets().get("B"));
        Assert.assertSame((Object)target, (Object)o1.getTargets().get("B1"));
    }
}

