/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.query.SQLTemplate;
import org.junit.Assert;
import org.junit.Test;

public class SQLTemplateDescriptorTest {
    @Test
    public void testGetQueryType() throws Exception {
        SQLTemplateDescriptor builder = QueryDescriptor.sqlTemplateDescriptor();
        Assert.assertTrue((boolean)(builder.buildQuery() instanceof SQLTemplate));
    }

    @Test
    public void testGetQueryRoot() throws Exception {
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("A");
        map.addObjEntity(entity);
        SQLTemplateDescriptor builder = QueryDescriptor.sqlTemplateDescriptor();
        builder.setRoot(entity);
        SQLTemplate query = builder.buildQuery();
        Assert.assertTrue((boolean)(query instanceof SQLTemplate));
        Assert.assertSame((Object)entity, (Object)query.getRoot());
    }

    @Test
    public void testGetQueryProperties() throws Exception {
        SQLTemplateDescriptor builder = QueryDescriptor.sqlTemplateDescriptor();
        builder.setProperty("cayenne.GenericSelectQuery.fetchLimit", "5");
        builder.setProperty("cayenne.GenericSelectQuery.statementFetchSize", "6");
        SQLTemplate query = builder.buildQuery();
        Assert.assertTrue((boolean)(query instanceof SQLTemplate));
        Assert.assertEquals((long)5L, (long)query.getFetchLimit());
        Assert.assertEquals((long)6L, (long)query.getStatementFetchSize());
    }

    @Test
    public void testGetQuerySql() throws Exception {
        SQLTemplateDescriptor builder = QueryDescriptor.sqlTemplateDescriptor();
        builder.setSql("abc");
        SQLTemplate query = builder.buildQuery();
        Assert.assertEquals((Object)"abc", (Object)query.getDefaultTemplate());
    }

    @Test
    public void testGetQueryAdapterSql() throws Exception {
        SQLTemplateDescriptor builder = QueryDescriptor.sqlTemplateDescriptor();
        builder.getAdapterSql().put("adapter", "abc");
        SQLTemplate query = builder.buildQuery();
        Assert.assertNull((Object)query.getDefaultTemplate());
        Assert.assertEquals((Object)"abc", (Object)query.getTemplate("adapter"));
    }
}

