/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.cayenne.datasource.ManagedPoolingDataSource;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ManagedPoolingDataSourceTest {
    private Connection[] mockConnections;
    private UnmanagedPoolingDataSource mockPoolingDataSource;
    private ManagedPoolingDataSource dataSource;

    @Before
    public void before() throws SQLException {
        this.mockConnections = new Connection[4];
        for (int i = 0; i < this.mockConnections.length; ++i) {
            this.mockConnections[i] = (Connection)Mockito.mock(Connection.class);
        }
        this.mockPoolingDataSource = (UnmanagedPoolingDataSource)Mockito.mock(UnmanagedPoolingDataSource.class);
        Mockito.when((Object)this.mockPoolingDataSource.getConnection()).thenReturn((Object)this.mockConnections[0], (Object[])new Connection[]{this.mockConnections[1], this.mockConnections[2], this.mockConnections[3]});
        this.dataSource = new ManagedPoolingDataSource(this.mockPoolingDataSource);
    }

    @After
    public void after() {
        this.dataSource.beforeScopeEnd();
    }

    @Test
    public void testGetConnection() throws SQLException {
        Assert.assertSame((Object)this.mockConnections[0], (Object)this.dataSource.getConnection());
        Assert.assertSame((Object)this.mockConnections[1], (Object)this.dataSource.getConnection());
        Assert.assertSame((Object)this.mockConnections[2], (Object)this.dataSource.getConnection());
        Assert.assertSame((Object)this.mockConnections[3], (Object)this.dataSource.getConnection());
    }

    @Test
    public void testClose() throws SQLException, InterruptedException {
        Assert.assertNotNull((Object)this.dataSource.getConnection());
        ((UnmanagedPoolingDataSource)Mockito.verify((Object)this.mockPoolingDataSource, (VerificationMode)Mockito.times((int)0))).close();
        Assert.assertFalse((boolean)this.dataSource.getDataSourceManager().isStopped());
        Assert.assertTrue((boolean)this.dataSource.getDataSourceManager().isAlive());
        this.dataSource.close();
        ((UnmanagedPoolingDataSource)Mockito.verify((Object)this.mockPoolingDataSource, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)this.dataSource.getDataSourceManager().isStopped());
        Thread.sleep(200L);
        Assert.assertFalse((boolean)this.dataSource.getDataSourceManager().isAlive());
        try {
            this.dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

