/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.sql.Driver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.datasource.DataSourceBuilder;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class ServerCaseDataSourceFactory {
    private DataSource sharedDataSource;
    private DataSourceInfo dataSourceInfo;
    private Map<String, DataSource> dataSources;
    private Set<String> mapsWithDedicatedDataSource;
    private AdhocObjectFactory objectFactory;

    public ServerCaseDataSourceFactory(@Inject DataSourceInfo dataSourceInfo, @Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.dataSourceInfo = dataSourceInfo;
        this.dataSources = new HashMap<String, DataSource>();
        this.mapsWithDedicatedDataSource = new HashSet<String>(Arrays.asList("map-db1", "map-db2"));
        this.sharedDataSource = this.createDataSource();
    }

    public DataSource getSharedDataSource() {
        return this.sharedDataSource;
    }

    public DataSource getDataSource(String dataMapName) {
        DataSource ds = this.dataSources.get(dataMapName);
        if (ds == null) {
            ds = this.mapsWithDedicatedDataSource.contains(dataMapName) ? this.createDataSource() : this.sharedDataSource;
            this.dataSources.put(dataMapName, ds);
        }
        return ds;
    }

    private DataSource createDataSource() {
        Driver driver = (Driver)this.objectFactory.newInstance(Driver.class, this.dataSourceInfo.getJdbcDriver());
        return DataSourceBuilder.url(this.dataSourceInfo.getDataSourceUrl()).driver(driver).userName(this.dataSourceInfo.getUserName()).password(this.dataSourceInfo.getPassword()).pool(this.dataSourceInfo.getMinConnections(), this.dataSourceInfo.getMaxConnections()).build();
    }
}

