/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.cayenne.exp.parser.ASTIn;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTNotIn;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Test;

public class ASTInTest {
    @Test
    public void testToEJBQL_in() throws IOException {
        ASTIn e = new ASTIn(new ASTObjPath("consignment.parts"), new ASTList(new Object[]{91, 23}));
        Assert.assertEquals((Object)"x.consignment.parts in (91, 23)", (Object)e.toEJBQL("x"));
    }

    @Test
    public void testEvaluate() {
        ASTIn in = new ASTIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        ASTNotIn notIn = new ASTNotIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        Painting noMatch1 = new Painting();
        noMatch1.setEstimatedPrice(new BigDecimal("21"));
        Assert.assertFalse((boolean)in.match(noMatch1));
        Assert.assertTrue((boolean)notIn.match(noMatch1));
        Painting noMatch2 = new Painting();
        noMatch2.setEstimatedPrice(new BigDecimal("11"));
        Assert.assertFalse((String)("Failed: " + in), (boolean)in.match(noMatch2));
        Assert.assertTrue((String)("Failed: " + notIn), (boolean)notIn.match(noMatch2));
        Painting match1 = new Painting();
        match1.setEstimatedPrice(new BigDecimal("20"));
        Assert.assertTrue((boolean)in.match(match1));
        Assert.assertFalse((boolean)notIn.match(match1));
        Painting match2 = new Painting();
        match2.setEstimatedPrice(new BigDecimal("10"));
        Assert.assertTrue((String)("Failed: " + in), (boolean)in.match(match2));
        Assert.assertFalse((String)("Failed: " + notIn), (boolean)notIn.match(match2));
    }

    @Test
    public void testEvaluate_Null() {
        ASTIn in = new ASTIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        ASTNotIn notIn = new ASTNotIn(new ASTObjPath("estimatedPrice"), new ASTList(new Object[]{new BigDecimal("10"), new BigDecimal("20")}));
        Painting noMatch = new Painting();
        Assert.assertFalse((boolean)in.match(noMatch));
        Assert.assertFalse((boolean)notIn.match(noMatch));
    }
}

