/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.PerAdapterProvider;
import org.apache.cayenne.dba.derby.DerbyAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.log.Slf4jJdbcEventLogger;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PerAdapterProviderTest {
    private OracleAdapter oracleAdapter;
    private DerbyAdapter derbyAdapter;
    private AutoAdapter autoDerbyAdapter;

    @Before
    public void before() {
        ClassLoaderResourceLocator locator = new ClassLoaderResourceLocator((ClassLoaderManager)new DefaultClassLoaderManager());
        RuntimeProperties runtimeProperties = (RuntimeProperties)Mockito.mock(RuntimeProperties.class);
        ValueObjectTypeRegistry valueObjectTypeRegistry = (ValueObjectTypeRegistry)Mockito.mock(ValueObjectTypeRegistry.class);
        this.oracleAdapter = new OracleAdapter(runtimeProperties, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), locator, valueObjectTypeRegistry);
        this.derbyAdapter = new DerbyAdapter(runtimeProperties, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), locator, valueObjectTypeRegistry);
        this.autoDerbyAdapter = new AutoAdapter(new Provider<DbAdapter>(){

            public DbAdapter get() throws DIRuntimeException {
                return PerAdapterProviderTest.this.derbyAdapter;
            }
        }, new Slf4jJdbcEventLogger(runtimeProperties));
    }

    @Test
    public void testGet() {
        Map<String, String> map = Collections.singletonMap(DerbyAdapter.class.getName(), "x");
        PerAdapterProvider<String> provider = new PerAdapterProvider<String>(map, "default");
        Assert.assertEquals((Object)"default", (Object)provider.get(this.oracleAdapter));
        Assert.assertEquals((Object)"x", (Object)provider.get(this.derbyAdapter));
        Assert.assertEquals((Object)"x", (Object)provider.get(this.autoDerbyAdapter));
    }
}

