/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_vertical.IvImpl;
import org.apache.cayenne.testdo.inheritance_vertical.IvOther;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-inheritance-vertical.xml")
public class VerticalInheritanceMultipleAttributes
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected ServerRuntime runtime;
    TableHelper ivOtherTable;
    TableHelper ivBaseTable;
    TableHelper ivImplTable;

    @Before
    public void setupTableHelpers() throws Exception {
        this.ivOtherTable = new TableHelper(this.dbHelper, "IV_OTHER");
        this.ivOtherTable.setColumns(new String[]{"ID", "NAME"}).setColumnTypes(new int[]{4, 12});
        this.ivBaseTable = new TableHelper(this.dbHelper, "IV_BASE");
        this.ivBaseTable.setColumns(new String[]{"ID", "NAME", "TYPE"}).setColumnTypes(new int[]{4, 12, 1});
        this.ivImplTable = new TableHelper(this.dbHelper, "IV_IMPL");
        this.ivImplTable.setColumns(new String[]{"ID", "ATTR1", "ATTR2", "OTHER1_ID", "OTHER2_ID"}).setColumnTypes(new int[]{4, 12, 12, 4, 4});
        this.ivImplTable.deleteAll();
        this.ivBaseTable.deleteAll();
        this.ivOtherTable.deleteAll();
    }

    @Test
    public void testUpdateTwoObjects() throws SQLException {
        this.ivOtherTable.insert(new Object[]{1, "other1"});
        this.ivOtherTable.insert(new Object[]{2, "other2"});
        this.ivBaseTable.insert(new Object[]{1, "Impl 1", "I"});
        this.ivBaseTable.insert(new Object[]{2, "Impl 2", "I"});
        this.ivImplTable.insert(new Object[]{1, "attr1", "attr2", 1, 2});
        this.ivImplTable.insert(new Object[]{2, "attr1", "attr2", 1, 2});
        IvOther other1 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other1")).selectOne(this.context);
        IvOther other2 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other2")).selectOne(this.context);
        List implResult = ObjectSelect.query(IvImpl.class).select(this.context);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            record.setName(record.getName() + "-Change");
            record.setAttr1(record.getAttr1() + "-Change");
            record.setAttr2(record.getAttr2() + "-Change");
            record.setOther1(other2);
            record.setOther2(other1);
        }
        this.context.commitChanges();
        ObjectContext cleanContext = this.runtime.newContext();
        implResult = ObjectSelect.query(IvImpl.class).select(cleanContext);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            Assert.assertTrue((boolean)record.getName().endsWith("-Change"));
            Assert.assertTrue((boolean)record.getAttr1().endsWith("-Change"));
            Assert.assertTrue((boolean)record.getAttr2().endsWith("-Change"));
            Assert.assertEquals((Object)other2.getObjectId(), (Object)record.getOther1().getObjectId());
            Assert.assertEquals((Object)other1.getObjectId(), (Object)record.getOther2().getObjectId());
        }
    }

    @Test
    public void testCreateObjectsWithData() throws SQLException {
        this.ivOtherTable.insert(new Object[]{1, "other1"});
        this.ivOtherTable.insert(new Object[]{2, "other2"});
        IvOther other1 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other1")).selectOne(this.context);
        IvOther other2 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other2")).selectOne(this.context);
        IvImpl impl1 = this.context.newObject(IvImpl.class);
        impl1.setName("name");
        impl1.setAttr1("attr1");
        impl1.setAttr2("attr2");
        impl1.setOther1(other1);
        impl1.setOther2(other2);
        IvImpl impl2 = this.context.newObject(IvImpl.class);
        impl2.setName("name");
        impl2.setAttr1("attr1");
        impl2.setAttr2("attr2");
        impl2.setOther1(other1);
        impl2.setOther2(other2);
        this.context.commitChanges();
        ObjectContext cleanContext = this.runtime.newContext();
        List implResult = ObjectSelect.query(IvImpl.class).select(cleanContext);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            Assert.assertEquals((Object)"name", (Object)record.getName());
            Assert.assertEquals((Object)"attr1", (Object)record.getAttr1());
            Assert.assertEquals((Object)"attr2", (Object)record.getAttr2());
            Assert.assertEquals((Object)other1.getObjectId(), (Object)record.getOther1().getObjectId());
            Assert.assertEquals((Object)other2.getObjectId(), (Object)record.getOther2().getObjectId());
        }
    }

    @Test
    public void testCreateEmptyObjects() throws SQLException {
        IvImpl impl1 = this.context.newObject(IvImpl.class);
        impl1.setName("name");
        IvImpl impl2 = this.context.newObject(IvImpl.class);
        impl2.setName("name");
        this.context.commitChanges();
        ObjectContext cleanContext = this.runtime.newContext();
        List implResult = ObjectSelect.query(IvImpl.class).select(cleanContext);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            Assert.assertEquals((Object)"name", (Object)record.getName());
            Assert.assertNull((Object)record.getAttr1());
            Assert.assertNull((Object)record.getAttr2());
            Assert.assertNull((Object)record.getOther1());
            Assert.assertNull((Object)record.getOther2());
        }
    }

    @Test
    public void testCreateEmptyObjectsWithUpdate() throws SQLException {
        this.ivOtherTable.insert(new Object[]{1, "other1"});
        this.ivOtherTable.insert(new Object[]{2, "other2"});
        IvOther other1 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other1")).selectOne(this.context);
        IvOther other2 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other2")).selectOne(this.context);
        IvImpl impl1 = this.context.newObject(IvImpl.class);
        impl1.setName("name");
        IvImpl impl2 = this.context.newObject(IvImpl.class);
        impl2.setName("name");
        this.context.commitChanges();
        ObjectContext cleanContext = this.runtime.newContext();
        List implResult = ObjectSelect.query(IvImpl.class).select(cleanContext);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            Assert.assertEquals((Object)"name", (Object)record.getName());
            Assert.assertNull((Object)record.getAttr1());
            Assert.assertNull((Object)record.getAttr2());
            Assert.assertNull((Object)record.getOther1());
            Assert.assertNull((Object)record.getOther2());
        }
        impl1.setAttr1("attr1");
        impl1.setAttr2("attr2");
        impl1.setOther1(other1);
        impl1.setOther2(other2);
        impl2.setAttr1("attr1");
        impl2.setAttr2("attr2");
        impl2.setOther1(other1);
        impl2.setOther2(other2);
        this.context.commitChanges();
        cleanContext = this.runtime.newContext();
        implResult = ObjectSelect.query(IvImpl.class).select(cleanContext);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            Assert.assertEquals((Object)"name", (Object)record.getName());
            Assert.assertEquals((Object)"attr1", (Object)record.getAttr1());
            Assert.assertEquals((Object)"attr2", (Object)record.getAttr2());
            Assert.assertEquals((Object)other1.getObjectId(), (Object)record.getOther1().getObjectId());
            Assert.assertEquals((Object)other2.getObjectId(), (Object)record.getOther2().getObjectId());
        }
    }

    @Test
    public void testPartialCreateObjectsWithUpdate() throws SQLException {
        this.ivOtherTable.insert(new Object[]{1, "other1"});
        this.ivOtherTable.insert(new Object[]{2, "other2"});
        IvOther other1 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other1")).selectOne(this.context);
        IvOther other2 = (IvOther)ObjectSelect.query(IvOther.class).where(IvOther.NAME.eq("other2")).selectOne(this.context);
        IvImpl impl1 = this.context.newObject(IvImpl.class);
        impl1.setName("name");
        impl1.setAttr1("attr1");
        IvImpl impl2 = this.context.newObject(IvImpl.class);
        impl2.setName("name");
        impl2.setAttr1("attr1");
        this.context.commitChanges();
        ObjectContext cleanContext = this.runtime.newContext();
        List implResult = ObjectSelect.query(IvImpl.class).select(cleanContext);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            Assert.assertEquals((Object)"name", (Object)record.getName());
            Assert.assertEquals((Object)"attr1", (Object)record.getAttr1());
            Assert.assertNull((Object)record.getAttr2());
            Assert.assertNull((Object)record.getOther1());
            Assert.assertNull((Object)record.getOther2());
        }
        impl1.setAttr1("attr1");
        impl1.setAttr2("attr2");
        impl1.setOther1(other1);
        impl1.setOther2(other2);
        impl2.setAttr1("attr1");
        impl2.setAttr2("attr2");
        impl2.setOther1(other1);
        impl2.setOther2(other2);
        this.context.commitChanges();
        cleanContext = this.runtime.newContext();
        implResult = ObjectSelect.query(IvImpl.class).select(cleanContext);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl record : implResult) {
            Assert.assertEquals((Object)"name", (Object)record.getName());
            Assert.assertEquals((Object)"attr1", (Object)record.getAttr1());
            Assert.assertEquals((Object)"attr2", (Object)record.getAttr2());
            Assert.assertEquals((Object)other1.getObjectId(), (Object)record.getOther1().getObjectId());
            Assert.assertEquals((Object)other2.getObjectId(), (Object)record.getOther2().getObjectId());
        }
    }

    @Test
    public void testDeleteObjects() throws SQLException {
        this.ivOtherTable.insert(new Object[]{1, "other1"});
        this.ivOtherTable.insert(new Object[]{2, "other2"});
        this.ivBaseTable.insert(new Object[]{1, "Impl 1", "I"});
        this.ivBaseTable.insert(new Object[]{2, "Impl 2", "I"});
        this.ivImplTable.insert(new Object[]{1, "attr1", "attr2", 1, 2});
        this.ivImplTable.insert(new Object[]{2, "attr1", "attr2", 1, 2});
        List implResult = ObjectSelect.query(IvImpl.class).select(this.context);
        Assert.assertEquals((long)2L, (long)implResult.size());
        for (IvImpl iv : implResult) {
            this.context.deleteObject(iv);
        }
        this.context.commitChanges();
        Assert.assertEquals((long)0L, (long)ObjectSelect.query(IvImpl.class).selectCount(this.context));
    }
}

