/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.parser;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.template.Context;
import org.apache.cayenne.template.DefaultTemplateContextFactory;
import org.apache.cayenne.template.TemplateContextFactory;
import org.apache.cayenne.template.parser.ParseException;
import org.apache.cayenne.template.parser.SQLTemplateParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SQLTemplateParserTest {
    private TemplateContextFactory contextFactory;

    @Before
    public void setUp() {
        this.contextFactory = new DefaultTemplateContextFactory();
    }

    @Test
    public void testUnchangedParse() throws Exception {
        Context context = this.contextFactory.createContext(Collections.emptyMap());
        String template = "SELECT * FROM a";
        String sql = this.parseString(template, context);
        Assert.assertEquals((Object)template, (Object)sql);
    }

    @Test
    public void testParameterParse() throws Exception {
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", true));
        String template = "SELECT $a FROM a";
        String sql = this.parseString(template, context);
        Assert.assertEquals((Object)"SELECT true FROM a", (Object)sql);
    }

    @Test
    public void testIfElseParse() throws Exception {
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", true));
        String template = "SELECT #if($a) * #else 1 #end FROM a";
        String sql = this.parseString(template, context);
        Assert.assertEquals((Object)"SELECT  *  FROM a", (Object)sql);
        context = this.contextFactory.createContext(Collections.singletonMap("a", false));
        template = "SELECT #if($a) * #else 1 #end FROM a";
        sql = this.parseString(template, context);
        Assert.assertEquals((Object)"SELECT  1  FROM a", (Object)sql);
    }

    @Test
    public void testBindParse() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "var");
        parameters.put("b", "bbb");
        Context context = this.contextFactory.createContext(parameters);
        String template = "SELECT #if($a) #bind($a, 'INT' ,2) #else #bind($b, 'CHAR' ,2) #end FROM a";
        String sql = this.parseString(template, context);
        Assert.assertEquals((Object)"SELECT  ?  FROM a", (Object)sql);
        Assert.assertEquals((long)1L, (long)context.getParameterBindings().length);
        Assert.assertEquals((Object)"var", (Object)context.getParameterBindings()[0].getValue());
    }

    @Test
    public void testComplexParse() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("a", "var");
        class Helper {
            Helper() {
            }

            public String cayenneExp(Object obj, String exp) {
                return "aaaa";
            }
        }
        parameters.put("myHelper", new Helper());
        String template = "SELECT * \nFROM ME\n#if($a) \nWHERE \nCOLUMN1 #bind($myHelper.cayenneExp($a, 'db:ID_COLUMN1'), 'INT')\n     \tAND \nCOLUMN2 #bind($myHelper.cayenneExp($a, 'db:ID_COLUMN2'), 'VARCHAR')\n#end\n";
        Context context = this.contextFactory.createContext(parameters);
        String sql = this.parseString(template, context);
        Assert.assertEquals((Object)"SELECT * \nFROM ME\n \nWHERE \nCOLUMN1 ?\n     \tAND \nCOLUMN2 ?\n\n", (Object)sql);
        Assert.assertEquals((long)2L, (long)context.getParameterBindings().length);
        Assert.assertEquals((Object)"aaaa", (Object)context.getParameterBindings()[0].getValue());
    }

    @Test
    public void testComplexParse2() throws Exception {
        String tpl = "SELECT #result('t0.BIGDECIMAL_FIELD' 'java.math.BigDecimal' 'ec0_0' 'ec0_0' 2), #result('t0.ID' 'java.lang.Integer' 'ec0_1' 'ec0_1' 4) FROM BIGDECIMAL_ENTITY t0 WHERE {fn ABS( t0.BIGDECIMAL_FIELD)} < #bind($id0 'DECIMAL')";
        Context context = this.contextFactory.createContext(Collections.singletonMap("id0", 123));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"SELECT t0.BIGDECIMAL_FIELD AS ec0_0, t0.ID AS ec0_1 FROM BIGDECIMAL_ENTITY t0 WHERE {fn ABS( t0.BIGDECIMAL_FIELD)} < ?", (Object)sql);
        Assert.assertEquals((long)1L, (long)context.getParameterBindings().length);
        Assert.assertEquals((long)2L, (long)context.getColumnDescriptors().length);
    }

    @Test
    public void testComplexParse3() throws Exception {
        String tpl = "SELECT #result('COUNT(*)' 'java.lang.Long' 'sc0'), #result('t0.ARTIST_NAME' 'java.lang.String' 'ec1_0' 'ec1_0' 1), #result('t0.DATE_OF_BIRTH' 'java.util.Date' 'ec1_1' 'ec1_1' 91), #result('t0.ARTIST_ID' 'java.lang.Long' 'ec1_2' 'ec1_2' -5), #result('SUM(t1.ESTIMATED_PRICE)' 'java.math.BigDecimal' 'sc2') FROM ARTIST t0 LEFT OUTER JOIN PAINTING t1 ON (t0.ARTIST_ID = t1.ARTIST_ID) GROUP BY t0.ARTIST_NAME, t0.DATE_OF_BIRTH, t0.ARTIST_ID ORDER BY t0.ARTIST_NAME";
        Context context = this.contextFactory.createContext(Collections.emptyMap());
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((long)5L, (long)context.getColumnDescriptors().length);
        Assert.assertEquals((Object)"SELECT COUNT(*) AS sc0, t0.ARTIST_NAME AS ec1_0, t0.DATE_OF_BIRTH AS ec1_1, t0.ARTIST_ID AS ec1_2, SUM(t1.ESTIMATED_PRICE) AS sc2 FROM ARTIST t0 LEFT OUTER JOIN PAINTING t1 ON (t0.ARTIST_ID = t1.ARTIST_ID) GROUP BY t0.ARTIST_NAME, t0.DATE_OF_BIRTH, t0.ARTIST_ID ORDER BY t0.ARTIST_NAME", (Object)sql);
    }

    @Test
    public void testHelperObject() throws Exception {
        String tpl = "($helper.cayenneExp($a, 'field'))";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"(5)", (Object)sql);
    }

    @Test
    public void testMethodCallArray() throws Exception {
        String tpl = "$a.arrayMethod(['1' '2' '3'])";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"array_3", (Object)sql);
    }

    @Test
    public void testMethodCallInt() throws Exception {
        String tpl = "$a.intMethod(42)";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"int_42", (Object)sql);
    }

    @Test
    public void testMethodCallString() throws Exception {
        String tpl = "$a.stringMethod(\"abc\")";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"string_abc", (Object)sql);
    }

    @Test
    public void testMethodCallFloat() throws Exception {
        String tpl = "$a.floatMethod(3.14)";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"float_3.14", (Object)sql);
    }

    @Test
    @Ignore(value="Method overload not properly supported, this test can return m2_true")
    public void testMethodCallSelectByArgType1() throws Exception {
        String tpl = "$a.method(123)";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"m1_123", (Object)sql);
    }

    @Test
    public void testMethodCallSelectByArgType2() throws Exception {
        String tpl = "$a.method(true)";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"m2_true", (Object)sql);
    }

    @Test
    public void testPropertyAccess() throws Exception {
        String tpl = "$a.field()";
        Context context = this.contextFactory.createContext(Collections.singletonMap("a", new TestBean(5)));
        String sql = this.parseString(tpl, context);
        Assert.assertEquals((Object)"5", (Object)sql);
    }

    @Test
    public void testNestedBrackets() throws Exception {
        String tpl = "(#bind('A' 'b'))";
        String sql = this.parseString(tpl, this.contextFactory.createContext(Collections.emptyMap()));
        Assert.assertEquals((Object)"(?)", (Object)sql);
    }

    @Test
    public void testQuotes() throws Exception {
        String template = "\"$a\"";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "val");
        Context context = this.contextFactory.createContext(parameters);
        String sql = this.parseString(template, context);
        Assert.assertEquals((Object)"\"val\"", (Object)sql);
        context = this.contextFactory.createContext(parameters);
        template = "'$a'";
        sql = this.parseString(template, context);
        Assert.assertEquals((Object)"'val'", (Object)sql);
    }

    @Test
    public void testComma() throws Exception {
        String template = "$a,$a";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "val");
        Context context = this.contextFactory.createContext(parameters);
        String sql = this.parseString(template, context);
        Assert.assertEquals((Object)"val,val", (Object)sql);
    }

    private String parseString(String tpl, Context context) throws ParseException {
        new SQLTemplateParser(new ByteArrayInputStream(tpl.getBytes())).template().evaluate(context);
        return context.buildTemplate();
    }

    public static class TestBean {
        private int field;

        TestBean(int field) {
            this.field = field;
        }

        public int getField() {
            return this.field;
        }

        public String arrayMethod(Object[] array) {
            return "array_" + array.length;
        }

        public String stringMethod(String string) {
            return "string_" + string;
        }

        public String intMethod(int i) {
            return "int_" + i;
        }

        public String floatMethod(float f) {
            return "float_" + f;
        }

        public String method(int i) {
            return "m1_" + i;
        }

        public String method(boolean b) {
            return "m2_" + b;
        }
    }
}

