/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.cayenne.access.types.BigDecimalType;
import org.apache.cayenne.access.types.DefaultValueObjectTypeRegistry;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.MockExtendedType;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ValueObjectTypeFactoryTest {
    ExtendedType tstType1;
    ExtendedType tstType2;
    ExtendedType tstType3;
    ExtendedType tstType4;
    ExtendedType tstType5;
    ValueObjectTypeFactory factory;

    @Before
    public void setUpRegistry() {
        ArrayList list = new ArrayList();
        list.add(this.createMockValueType(UUID.class, byte[].class));
        list.add(this.createMockValueType(String.class, String.class));
        list.add(this.createMockValueType(Integer.TYPE, Integer.TYPE));
        list.add(this.createMockValueType(String[].class, String[].class));
        list.add(this.createMockValueType(TestClass.class, BigDecimal.class));
        DefaultValueObjectTypeRegistry registry = new DefaultValueObjectTypeRegistry(list);
        ExtendedTypeMap extendedTypeMap = new ExtendedTypeMap();
        this.tstType1 = (ExtendedType)Mockito.mock(ExtendedType.class);
        Mockito.when((Object)this.tstType1.getClassName()).thenReturn((Object)"byte[]");
        extendedTypeMap.registerType(this.tstType1);
        this.tstType2 = new MockExtendedType(String.class);
        extendedTypeMap.registerType(this.tstType2);
        this.tstType3 = new MockExtendedType(Integer.TYPE);
        extendedTypeMap.registerType(this.tstType3);
        this.tstType4 = (ExtendedType)Mockito.mock(ExtendedType.class);
        Mockito.when((Object)this.tstType4.getClassName()).thenReturn((Object)String[].class.getCanonicalName());
        extendedTypeMap.registerType(this.tstType4);
        this.tstType5 = new MockExtendedType(BigDecimal.class);
        extendedTypeMap.registerType(this.tstType5);
        this.factory = new ValueObjectTypeFactory(extendedTypeMap, registry);
    }

    private ValueObjectType createMockValueType(Class<?> valueClass, Class<?> targetClass) {
        ValueObjectType valueObjectType = (ValueObjectType)Mockito.mock(ValueObjectType.class);
        Mockito.when(valueObjectType.getValueType()).thenReturn(valueClass);
        Mockito.when(valueObjectType.getTargetType()).thenReturn(targetClass);
        return valueObjectType;
    }

    @Test
    public void testUUIDtoByteArray() {
        ValueObjectTypeFactory.ExtendedTypeConverter converter1 = (ValueObjectTypeFactory.ExtendedTypeConverter)this.factory.getType(UUID.class);
        Assert.assertNotNull((Object)converter1);
        Assert.assertSame((Object)this.tstType1, converter1.extendedType);
    }

    @Test
    public void testString() {
        ValueObjectTypeFactory.ExtendedTypeConverter converter2 = (ValueObjectTypeFactory.ExtendedTypeConverter)this.factory.getType(String.class);
        Assert.assertNotNull((Object)converter2);
        Assert.assertSame((Object)this.tstType2, converter2.extendedType);
    }

    @Test
    public void testInt() {
        ValueObjectTypeFactory.ExtendedTypeConverter converter3 = (ValueObjectTypeFactory.ExtendedTypeConverter)this.factory.getType(Integer.TYPE);
        Assert.assertNotNull((Object)converter3);
        Assert.assertSame((Object)this.tstType3, converter3.extendedType);
    }

    @Test
    public void testStringArray() {
        ValueObjectTypeFactory.ExtendedTypeConverter converter4 = (ValueObjectTypeFactory.ExtendedTypeConverter)this.factory.getType(String[].class);
        Assert.assertNotNull((Object)converter4);
        Assert.assertSame((Object)this.tstType4, converter4.extendedType);
    }

    @Test
    public void testInheritantType() {
        ValueObjectTypeFactory.ExtendedTypeConverter converter5 = (ValueObjectTypeFactory.ExtendedTypeConverter)this.factory.getType(TestClass.class);
        Assert.assertNotNull((Object)converter5);
        Assert.assertSame((Object)this.tstType5, converter5.extendedType);
    }

    @Test
    public void testInheritantValueTypeOverExtendedType() {
        BigDecimalType bigDecimalType = new BigDecimalType();
        ExtendedTypeMap map = new ExtendedTypeMap();
        map.registerType(bigDecimalType);
        ArrayList list = new ArrayList();
        ValueObjectType valueObjectType = (ValueObjectType)Mockito.mock(ValueObjectType.class);
        Mockito.when(valueObjectType.getValueType()).thenReturn(TestClass.class);
        Mockito.when(valueObjectType.getTargetType()).thenReturn(BigDecimal.class);
        list.add(valueObjectType);
        DefaultValueObjectTypeRegistry registry = new DefaultValueObjectTypeRegistry(list);
        map.addFactory(new ValueObjectTypeFactory(map, registry));
        ExtendedType type1 = map.getRegisteredType(BigDecimal.class);
        Assert.assertSame((Object)bigDecimalType, (Object)type1);
        ExtendedType type2 = map.getRegisteredType(TestClass.class);
        Assert.assertThat((Object)type2, (Matcher)CoreMatchers.instanceOf(ValueObjectTypeFactory.ExtendedTypeConverter.class));
        Assert.assertSame((Object)valueObjectType, ((ValueObjectTypeFactory.ExtendedTypeConverter)type2).valueObjectType);
    }

    private class TestClass
    extends BigDecimal {
        public TestClass(long val) {
            super(val);
        }
    }
}

