/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Date;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextExtrasIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected JdbcEventLogger logger;
    @Inject
    protected AdhocObjectFactory objectFactory;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    protected void createPhantomModificationDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
    }

    protected void createPhantomModificationsValidateToOneDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tPainting.insert(new Object[]{33001, 33001, "P1", 3000});
    }

    protected void createValidateOnToManyChangeDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
    }

    protected void createPhantomRelationshipModificationCommitDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tPainting.insert(new Object[]{33001, 33001, "P1", 3000});
    }

    @Test
    public void testManualIdProcessingOnCommit() throws Exception {
        Artist object = this.context.newObject(Artist.class);
        object.setArtistName("ABC");
        Assert.assertEquals((long)2L, (long)object.getPersistenceState());
        ObjectId manualId = new ObjectId("Artist", "ARTIST_ID", 77777);
        object.setObjectId(manualId);
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)object.getPersistenceState());
        Assert.assertSame((Object)object, (Object)this.context.getGraphManager().getNode(manualId));
        Assert.assertEquals((Object)manualId, (Object)object.getObjectId());
    }

    @Test
    public void testResolveFault() throws Exception {
        Artist o1 = this.context.newObject(Artist.class);
        o1.setArtistName("a");
        this.context.commitChanges();
        this.context.invalidateObjects(o1);
        Assert.assertEquals((long)5L, (long)o1.getPersistenceState());
        int count = this.tArtist.update().set("ARTIST_NAME", (Object)"b").execute();
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        this.context.prepareForAccess(o1, null, false);
        Assert.assertEquals((long)3L, (long)o1.getPersistenceState());
        Assert.assertEquals((Object)"b", (Object)o1.readPropertyDirectly("artistName"));
    }

    @Test
    public void testResolveFaultFailure() {
        Persistent o1 = this.context.findOrCreateObject(new ObjectId("Artist", "ARTIST_ID", 234));
        try {
            this.context.prepareForAccess(o1, null, false);
            Assert.fail((String)"Must blow on non-existing fault.");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testUserProperties() {
        Assert.assertNull((Object)this.context.getUserProperty("ABC"));
        Object object = new Object();
        this.context.setUserProperty("ABC", object);
        Assert.assertSame((Object)object, (Object)this.context.getUserProperty("ABC"));
    }

    @Test
    public void testHasChangesNew() {
        Assert.assertTrue((String)"No changes expected in context", (!this.context.hasChanges() ? 1 : 0) != 0);
        this.context.newObject("Artist");
        Assert.assertTrue((String)"Object added to context, expected to report changes", (boolean)this.context.hasChanges());
    }

    @Test
    public void testNewObject() {
        Artist a1 = (Artist)this.context.newObject("Artist");
        Assert.assertTrue((boolean)this.context.getGraphManager().registeredNodes().contains(a1));
        Assert.assertTrue((boolean)this.context.newObjects().contains(a1));
    }

    @Test
    public void testNewObjectWithClass() {
        Artist a1 = this.context.newObject(Artist.class);
        Assert.assertTrue((boolean)this.context.getGraphManager().registeredNodes().contains(a1));
        Assert.assertTrue((boolean)this.context.newObjects().contains(a1));
    }

    @Test
    public void testIdObjectFromDataRow() {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", 100000);
        DataObject obj = this.context.objectFromDataRow(Artist.class, row);
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)this.context.getGraphManager().registeredNodes().contains(obj));
        Assert.assertEquals((long)5L, (long)obj.getPersistenceState());
        Assert.assertNull((Object)this.context.getObjectStore().getCachedSnapshot(obj.getObjectId()));
    }

    @Test
    public void testPartialObjectFromDataRow() {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", 100001);
        row.put("ARTIST_NAME", "ArtistXYZ");
        DataObject obj = this.context.objectFromDataRow(Artist.class, row);
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)this.context.getGraphManager().registeredNodes().contains(obj));
        Assert.assertEquals((long)5L, (long)obj.getPersistenceState());
        Assert.assertNull((Object)this.context.getObjectStore().getCachedSnapshot(obj.getObjectId()));
    }

    @Test
    public void testFullObjectFromDataRow() {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", 123456);
        row.put("ARTIST_NAME", "ArtistXYZ");
        row.put("DATE_OF_BIRTH", new Date());
        Artist obj = this.context.objectFromDataRow(Artist.class, row);
        Assert.assertTrue((boolean)this.context.getGraphManager().registeredNodes().contains(obj));
        Assert.assertEquals((long)3L, (long)obj.getPersistenceState());
        Assert.assertNotNull((Object)this.context.getObjectStore().getCachedSnapshot(obj.getObjectId()));
        Assert.assertEquals((Object)"ArtistXYZ", (Object)obj.getArtistName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommitChangesError() {
        DataDomain domain = this.context.getParentDataDomain();
        JdbcAdapter jdbcAdapter = (JdbcAdapter)this.objectFactory.newInstance(JdbcAdapter.class, JdbcAdapter.class.getName());
        JdbcPkGenerator newGenerator = new JdbcPkGenerator(jdbcAdapter){

            @Override
            public Object generatePk(DataNode node, DbAttribute pk) throws Exception {
                throw new CayenneRuntimeException("Intentional", new Object[0]);
            }
        };
        PkGenerator oldGenerator = domain.getDataNodes().iterator().next().getAdapter().getPkGenerator();
        JdbcAdapter adapter = (JdbcAdapter)domain.getDataNodes().iterator().next().getAdapter();
        adapter.setPkGenerator(newGenerator);
        try {
            Artist newArtist = this.context.newObject(Artist.class);
            newArtist.setArtistName("aaa");
            this.context.commitChanges();
            Assert.fail((String)"Exception expected but not thrown due to missing PK generation routine.");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
        }
        finally {
            adapter.setPkGenerator(oldGenerator);
        }
    }

    @Test
    public void testSelectException() {
        SQLTemplate q = new SQLTemplate(Artist.class, "SELECT * FROM NON_EXISTENT_TABLE");
        try {
            this.context.performGenericQuery(q);
            Assert.fail((String)"Query was invalid and was supposed to fail.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testEntityResolver() {
        Assert.assertNotNull((Object)this.context.getEntityResolver());
    }

    @Test
    public void testPhantomModificationsValidate() throws Exception {
        this.createPhantomModificationDataSet();
        List objects = ObjectSelect.query(Artist.class).select(this.context);
        Artist a1 = (Artist)objects.get(0);
        Artist a2 = (Artist)objects.get(1);
        a1.setArtistName(a1.getArtistName());
        a1.resetValidationFlags();
        a2.resetValidationFlags();
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isValidateForSaveCalled());
        Assert.assertFalse((boolean)a2.isValidateForSaveCalled());
        a1.setArtistName(a1.getArtistName());
        a2.setArtistName(a2.getArtistName() + "_x");
        a1.resetValidationFlags();
        a2.resetValidationFlags();
        this.context.commitChanges();
        Assert.assertTrue((boolean)a2.isValidateForSaveCalled());
        Assert.assertFalse((boolean)a1.isValidateForSaveCalled());
    }

    @Test
    public void testPhantomModificationsValidateToOne() throws Exception {
        this.createPhantomModificationsValidateToOneDataSet();
        List objects = ObjectSelect.query(Painting.class).select(this.context);
        Painting p1 = (Painting)objects.get(0);
        p1.setPaintingTitle(p1.getPaintingTitle());
        p1.resetValidationFlags();
        this.context.commitChanges();
        Assert.assertFalse((String)"To-one relationship presence caused incorrect validation call.", (boolean)p1.isValidateForSaveCalled());
    }

    @Test
    public void testValidateOnToManyChange() throws Exception {
        this.createValidateOnToManyChangeDataSet();
        List objects = ObjectSelect.query(Artist.class).select(this.context);
        Artist a1 = (Artist)objects.get(0);
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("XXX");
        a1.addToPaintingArray(p1);
        a1.resetValidationFlags();
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isValidateForSaveCalled());
    }

    @Test
    public void testPhantomAttributeModificationCommit() throws Exception {
        this.createPhantomModificationDataSet();
        List objects = ObjectSelect.query(Artist.class).select(this.context);
        Artist a1 = (Artist)objects.get(0);
        String oldName = a1.getArtistName();
        a1.setArtistName(oldName + ".mod");
        a1.setArtistName(oldName);
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
    }

    @Test
    public void testPhantomRelationshipModificationCommit() throws Exception {
        this.createPhantomRelationshipModificationCommitDataSet();
        List objects = ObjectSelect.query(Painting.class).select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
        Painting p1 = (Painting)objects.get(0);
        Artist oldArtist = p1.getToArtist();
        Artist newArtist = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33002);
        Assert.assertNotSame((Object)oldArtist, (Object)newArtist);
        p1.setToArtist(newArtist);
        p1.setToArtist(oldArtist);
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)p1.getPersistenceState());
        Assert.assertEquals((long)3L, (long)oldArtist.getPersistenceState());
        Assert.assertEquals((long)3L, (long)newArtist.getPersistenceState());
    }

    @Test
    public void testPhantomRelationshipModificationValidate() throws Exception {
        this.createPhantomRelationshipModificationCommitDataSet();
        List objects = ObjectSelect.query(Painting.class).select(this.context);
        Assert.assertEquals((long)1L, (long)objects.size());
        Painting p1 = (Painting)objects.get(0);
        Artist oldArtist = p1.getToArtist();
        Artist newArtist = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33002);
        Assert.assertNotSame((Object)oldArtist, (Object)newArtist);
        p1.setToArtist(newArtist);
        p1.setToArtist(oldArtist);
        p1.resetValidationFlags();
        this.context.commitChanges();
        Assert.assertFalse((boolean)p1.isValidateForSaveCalled());
    }
}

