/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.ROPainting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CayenneDataObjectSetToManyListIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID"}).setColumnTypes(new int[]{4, 12, -5});
        this.createArtistWithPaintingDataSet();
    }

    private void createArtistWithPaintingDataSet() throws Exception {
        this.tArtist.insert(new Object[]{8, "artist 8"});
        this.tPainting.insert(new Object[]{6, "painting 6", 8});
        this.tPainting.insert(new Object[]{7, "painting 7", 8});
        this.tPainting.insert(new Object[]{8, "painting 8", 8});
    }

    @Test
    public void testReadRO1() {
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 8);
        Assert.assertNotNull((Object)a1);
        List paints = ObjectSelect.query(ROPainting.class).where(ROPainting.TO_ARTIST.eq(a1)).select(this.context);
        Assert.assertEquals((long)3L, (long)paints.size());
        ROPainting rop1 = (ROPainting)paints.get(0);
        Assert.assertSame((Object)a1, (Object)rop1.getToArtist());
    }

    @Test
    public void testSetEmptyList1() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        artist.setToManyTarget(Artist.PAINTING_ARRAY.getName(), new ArrayList(0), true);
        List<Painting> paints = artist.getPaintingArray();
        Assert.assertEquals((long)0L, (long)paints.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetEmptyList2() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        artist.setToManyTarget(Artist.PAINTING_ARRAY.getName(), null, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonExistentRelName() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        artist.setToManyTarget("doesnotexist", new ArrayList(0), true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyRelName() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        artist.setToManyTarget("", new ArrayList(0), true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullRelName() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        artist.setToManyTarget(null, new ArrayList(0), true);
    }

    @Test
    public void testTotalDifferentPaintings() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        ArrayList<Painting> oldPaints = new ArrayList<Painting>(artist.getPaintingArray());
        Painting paintX = new Painting();
        paintX.setPaintingTitle("pantingX");
        Painting paintY = new Painting();
        paintY.setPaintingTitle("paintingY");
        Painting paintZ = new Painting();
        paintZ.setPaintingTitle("paintingZ");
        List<? extends DataObject> returnList = artist.setToManyTarget(Artist.PAINTING_ARRAY.getName(), Arrays.asList(paintX, paintY, paintZ), true);
        Assert.assertEquals((long)3L, (long)returnList.size());
        Assert.assertTrue((boolean)returnList.containsAll(oldPaints));
        List<Painting> newPaints = artist.getPaintingArray();
        Assert.assertEquals((long)3L, (long)newPaints.size());
        for (Painting oldPaint : oldPaints) {
            Assert.assertFalse((boolean)newPaints.contains(oldPaint));
        }
    }

    @Test
    public void testSamePaintings() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        ArrayList<Painting> oldPaints = new ArrayList<Painting>(artist.getPaintingArray());
        Painting paint6 = Cayenne.objectForPK(this.context, Painting.class, 6);
        Painting paint7 = Cayenne.objectForPK(this.context, Painting.class, 7);
        Painting paint8 = Cayenne.objectForPK(this.context, Painting.class, 8);
        List<Painting> newPaints = Arrays.asList(paint6, paint7, paint8);
        List<? extends DataObject> returnList = artist.setToManyTarget(Artist.PAINTING_ARRAY.getName(), newPaints, true);
        Assert.assertEquals((long)0L, (long)returnList.size());
        newPaints = artist.getPaintingArray();
        Assert.assertEquals((long)3L, (long)newPaints.size());
        Assert.assertEquals((long)3L, (long)oldPaints.size());
        Assert.assertTrue((boolean)newPaints.containsAll(oldPaints));
    }

    @Test
    public void testOldPlusNewPaintings() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        List<Painting> oldPaints = artist.getPaintingArray();
        ArrayList<Painting> newPaints = new ArrayList<Painting>(6);
        newPaints.addAll(oldPaints);
        Painting paintX = new Painting();
        paintX.setPaintingTitle("pantingX");
        Painting paintY = new Painting();
        paintY.setPaintingTitle("paintingY");
        Painting paintZ = new Painting();
        paintZ.setPaintingTitle("paintingZ");
        newPaints.add(paintX);
        newPaints.add(paintY);
        newPaints.add(paintZ);
        artist.setToManyTarget(Artist.PAINTING_ARRAY.getName(), newPaints, true);
        List<Painting> newPaints2 = artist.getPaintingArray();
        Painting paint6 = Cayenne.objectForPK(this.context, Painting.class, 6);
        Painting paint7 = Cayenne.objectForPK(this.context, Painting.class, 7);
        Painting paint8 = Cayenne.objectForPK(this.context, Painting.class, 8);
        Assert.assertEquals((long)6L, (long)newPaints2.size());
        Assert.assertTrue((boolean)newPaints2.contains(paintX));
        Assert.assertTrue((boolean)newPaints2.contains(paintY));
        Assert.assertTrue((boolean)newPaints2.contains(paintZ));
        Assert.assertTrue((boolean)newPaints2.contains(paint6));
        Assert.assertTrue((boolean)newPaints2.contains(paint7));
        Assert.assertTrue((boolean)newPaints2.contains(paint8));
    }

    @Test
    public void testRemoveOneOldAndAddOneNewPaintings() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        ArrayList<Painting> newPaints = new ArrayList<Painting>();
        Painting paint6 = artist.getPaintingArray().get(0);
        Painting paint7 = artist.getPaintingArray().get(1);
        Painting paint8 = artist.getPaintingArray().get(2);
        Painting paintX = new Painting();
        paintX.setPaintingTitle("pantingX");
        Painting paintY = new Painting();
        paintY.setPaintingTitle("paintingY");
        newPaints.add(paint6);
        newPaints.add(paint7);
        newPaints.add(paintX);
        newPaints.add(paintY);
        List<? extends DataObject> returnList = artist.setToManyTarget(Artist.PAINTING_ARRAY.getName(), newPaints, true);
        Assert.assertEquals((long)1L, (long)returnList.size());
        Assert.assertSame((Object)paint8, (Object)returnList.get(0));
        List<Painting> newPaints2 = artist.getPaintingArray();
        Assert.assertEquals((long)4L, (long)newPaints2.size());
        Assert.assertTrue((boolean)newPaints2.contains(paintX));
        Assert.assertTrue((boolean)newPaints2.contains(paintY));
        Assert.assertTrue((boolean)newPaints2.contains(paint6));
        Assert.assertTrue((boolean)newPaints2.contains(paint7));
    }

    @Test
    public void testRelationCollectionTypeList() {
        Artist artist = Cayenne.objectForPK(this.context, Artist.class, 8);
        Assert.assertTrue((boolean)(artist.readProperty(Artist.PAINTING_ARRAY.getName()) instanceof List));
        try {
            artist.setToManyTarget(Artist.PAINTING_ARRAY.getName(), new ArrayList(0), true);
        }
        catch (UnsupportedOperationException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)0L, (long)artist.getPaintingArray().size());
    }
}

