/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class EmbeddedAttribute
extends ObjAttribute {
    protected SortedMap<String, String> attributeOverrides = new TreeMap<String, String>();

    public EmbeddedAttribute() {
    }

    public EmbeddedAttribute(String name) {
        this();
        this.setName(name);
    }

    public EmbeddedAttribute(String name, String type, ObjEntity entity) {
        this();
        this.setName(name);
        this.setType(type);
        this.setEntity(entity);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("embedded-attribute").attribute("name", this.getName()).attribute("type", this.getType());
        for (Map.Entry<String, String> e : this.attributeOverrides.entrySet()) {
            encoder.start("embeddable-attribute-override").attribute("name", e.getKey()).attribute("db-attribute-path", e.getValue()).end();
        }
        encoder.end();
    }

    public Map<String, String> getAttributeOverrides() {
        return Collections.unmodifiableMap(this.attributeOverrides);
    }

    public Embeddable getEmbeddable() {
        if (this.type == null) {
            return null;
        }
        return this.getNonNullNamespace().getEmbeddable(this.type);
    }

    private ObjAttribute makeObjAttribute(EmbeddableAttribute embeddableAttribute) {
        String dbPath = (String)this.attributeOverrides.get(embeddableAttribute.getName());
        if (dbPath == null) {
            dbPath = embeddableAttribute.getDbAttributeName();
        }
        return this.makeObjAttribute(embeddableAttribute, dbPath);
    }

    private ObjAttribute makeObjAttribute(EmbeddableAttribute embeddableAttribute, String dbPath) {
        String fullName = this.getName() + "." + embeddableAttribute.getName();
        ObjAttribute oa = new ObjAttribute(fullName, embeddableAttribute.getType(), this.getEntity());
        oa.setDbAttributePath(dbPath);
        return oa;
    }

    public ObjAttribute getAttributeForDbPath(String dbPath) {
        Embeddable e = this.getEmbeddable();
        if (e == null) {
            return null;
        }
        EmbeddableAttribute ea = null;
        for (Map.Entry<String, String> override : this.attributeOverrides.entrySet()) {
            if (!dbPath.equals(override.getValue())) continue;
            ea = e.getAttribute(override.getKey());
            break;
        }
        if (ea == null) {
            ea = e.getAttributeForDbPath(dbPath);
        }
        if (ea != null) {
            return this.makeObjAttribute(ea, dbPath);
        }
        return null;
    }

    public ObjAttribute getAttribute(String name) {
        Embeddable e = this.getEmbeddable();
        if (e == null) {
            return null;
        }
        EmbeddableAttribute ea = e.getAttribute(name);
        if (ea == null) {
            return null;
        }
        return this.makeObjAttribute(ea);
    }

    public Collection<ObjAttribute> getAttributes() {
        Embeddable e = this.getEmbeddable();
        if (e == null) {
            return Collections.emptyList();
        }
        Collection<EmbeddableAttribute> embeddableAttributes = e.getAttributes();
        ArrayList<ObjAttribute> objectAttributes = new ArrayList<ObjAttribute>(embeddableAttributes.size());
        for (EmbeddableAttribute ea : embeddableAttributes) {
            objectAttributes.add(this.makeObjAttribute(ea));
        }
        return objectAttributes;
    }

    public void addAttributeOverride(String name, String dbAttributeName) {
        this.attributeOverrides.put(name, dbAttributeName);
    }

    public void removeAttributeOverride(String name) {
        this.attributeOverrides.remove(name);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Class<?> getJavaClass() {
        if (this.getType() == null) {
            return null;
        }
        try {
            return Util.getJavaClass(this.getType());
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Failed to load class for name '" + this.getType() + "': " + e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    final MappingNamespace getNonNullNamespace() {
        if (this.entity == null) {
            throw new CayenneRuntimeException("Embedded attribute '%s' has no parent Entity.", this.getName());
        }
        return this.entity.getNonNullNamespace();
    }
}

