/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.LifecycleListener;
import org.apache.cayenne.annotation.PostAdd;
import org.apache.cayenne.annotation.PostLoad;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostRemove;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.annotation.PrePersist;
import org.apache.cayenne.annotation.PreRemove;
import org.apache.cayenne.annotation.PreUpdate;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class LifecycleCallbackRegistryTest {
    LifecycleCallbackRegistry registry;

    @Before
    public void createRegistry() {
        EntityResolver entityResolver = (EntityResolver)Mockito.mock(EntityResolver.class);
        this.registry = new LifecycleCallbackRegistry(entityResolver);
        for (LifecycleEvent event : LifecycleEvent.values()) {
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).defaultListenersSize());
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).listenersSize());
        }
    }

    @Test
    public void addDefaultListener() throws Exception {
        LifecycleListener listener = (LifecycleListener)Mockito.mock(LifecycleListener.class);
        this.registry.addDefaultListener(listener);
        for (LifecycleEvent event : LifecycleEvent.values()) {
            Assert.assertEquals((long)1L, (long)this.registry.getHandler(event).defaultListenersSize());
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).listenersSize());
        }
    }

    @Test
    public void addDefaultListenerSingleType() throws Exception {
        for (LifecycleEvent event : LifecycleEvent.values()) {
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).defaultListenersSize());
            LifecycleListener listener = (LifecycleListener)Mockito.mock(LifecycleListener.class);
            this.registry.addDefaultListener(event, listener, LifecycleCallbackRegistryTest.nameToCamelCase(event.name()));
            Assert.assertEquals((long)1L, (long)this.registry.getHandler(event).defaultListenersSize());
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).listenersSize());
        }
    }

    @Test
    public void addListenerWithEntityClass() throws Exception {
        LifecycleListener listener = (LifecycleListener)Mockito.mock(LifecycleListener.class);
        this.registry.addListener(Object.class, listener);
        for (LifecycleEvent event : LifecycleEvent.values()) {
            Assert.assertEquals((long)1L, (long)this.registry.getHandler(event).listenersSize());
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).defaultListenersSize());
        }
    }

    @Test
    public void addListenerWithEntityClassSingleType() throws Exception {
        for (LifecycleEvent event : LifecycleEvent.values()) {
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).listenersSize());
            LifecycleListener listener = (LifecycleListener)Mockito.mock(LifecycleListener.class);
            this.registry.addListener(event, Object.class, listener, LifecycleCallbackRegistryTest.nameToCamelCase(event.name()));
            Assert.assertEquals((long)1L, (long)this.registry.getHandler(event).listenersSize());
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).defaultListenersSize());
        }
    }

    @Test
    public void addAnnotatedListener() {
        this.registry.addListener(new AnnotatedListener());
        for (LifecycleEvent event : LifecycleEvent.values()) {
            Assert.assertEquals((long)1L, (long)this.registry.getHandler(event).defaultListenersSize());
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).listenersSize());
        }
    }

    @Test
    public void addAnnotatedListenerWithEntityClass() {
        this.registry.addListener(new AnnotatedListenerWithEntity());
        for (LifecycleEvent event : LifecycleEvent.values()) {
            Assert.assertEquals((long)0L, (long)this.registry.getHandler(event).defaultListenersSize());
            Assert.assertEquals((long)1L, (long)this.registry.getHandler(event).listenersSize());
        }
    }

    private static String nameToCamelCase(String functionName) {
        String[] parts = functionName.split("_");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (first) {
                sb.append(part.toLowerCase());
                first = false;
                continue;
            }
            char[] chars = part.toLowerCase().toCharArray();
            chars[0] = Character.toTitleCase(chars[0]);
            sb.append(chars);
        }
        return sb.toString();
    }

    private static class AnnotatedListenerWithEntity {
        private AnnotatedListenerWithEntity() {
        }

        @PostAdd(value={Object.class})
        public void postAdd(Object object) {
        }

        @PostLoad(value={Object.class})
        public void postLoad(Object object) {
        }

        @PostPersist(value={Object.class})
        public void postPersist(Object object) {
        }

        @PostRemove(value={Object.class})
        public void postRemove(Object object) {
        }

        @PostUpdate(value={Object.class})
        public void postUpdate(Object object) {
        }

        @PrePersist(value={Object.class})
        public void prePersist(Object object) {
        }

        @PreRemove(value={Object.class})
        public void preRemove(Object object) {
        }

        @PreUpdate(value={Object.class})
        public void preUpdate(Object object) {
        }
    }

    private static class AnnotatedListener {
        private AnnotatedListener() {
        }

        @PostAdd
        public void postAdd(Object object) {
        }

        @PostLoad
        public void postLoad(Object object) {
        }

        @PostPersist
        public void postPersist(Object object) {
        }

        @PostRemove
        public void postRemove(Object object) {
        }

        @PostUpdate
        public void postUpdate(Object object) {
        }

        @PrePersist
        public void prePersist(Object object) {
        }

        @PreRemove
        public void preRemove(Object object) {
        }

        @PreUpdate
        public void preUpdate(Object object) {
        }
    }
}

