/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectQueryMetadata;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class SelectQueryMetadataCacheKeyTest {
    private ValueObjectTypeRegistry registry;
    private StringBuilder cacheKey;

    @Before
    public void createObjects() {
        this.registry = (ValueObjectTypeRegistry)Mockito.mock(ValueObjectTypeRegistry.class);
        ValueObjectType mockType = (ValueObjectType)Mockito.mock(ValueObjectType.class);
        Mockito.when(mockType.getValueType()).thenReturn(Double.class);
        Mockito.when((Object)mockType.toCacheKey(ArgumentMatchers.any())).thenReturn((Object)"<value placeholder>");
        Mockito.when(this.registry.getValueType((Class)ArgumentMatchers.eq(Double.class))).thenReturn((Object)mockType);
        TestValueType testType = new TestValueType();
        Mockito.when(this.registry.getValueType((Class)ArgumentMatchers.eq(TestValue.class))).thenReturn((Object)testType);
    }

    @Test
    public void cacheKeySimple() {
        ExpressionFactory.exp("field = 1", new Object[0]).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        ExpressionFactory.exp("field = 1", new Object[0]).traverse(this.newHandler());
        String s2 = this.cacheKey.toString();
        ExpressionFactory.exp("field = 2", new Object[0]).traverse(this.newHandler());
        String s3 = this.cacheKey.toString();
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
    }

    @Test
    public void cacheKeyWithList() {
        ExpressionFactory.exp("field in (1,2,3)", new Object[0]).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        ExpressionFactory.exp("field in (1,2,3)", new Object[0]).traverse(this.newHandler());
        String s2 = this.cacheKey.toString();
        ExpressionFactory.exp("field in (2,3,4)", new Object[0]).traverse(this.newHandler());
        String s3 = this.cacheKey.toString();
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
    }

    @Test
    public void cacheKeyWithValueObjectSimple() {
        ExpressionFactory.exp("field = 1.0", new Object[0]).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        Assert.assertTrue((boolean)s1.contains("<value placeholder>"));
    }

    @Test
    public void cacheKeyWithValueObjectList() {
        ExpressionFactory.exp("field in (1.0,2.0,3.0)", new Object[0]).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        Assert.assertTrue((boolean)s1.contains("<value placeholder>"));
    }

    @Test
    public void cacheKeyWithEnumValue() {
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)TestEnum.VALUE_1).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)TestEnum.VALUE_1).traverse(this.newHandler());
        String s2 = this.cacheKey.toString();
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)TestEnum.VALUE_2).traverse(this.newHandler());
        String s3 = this.cacheKey.toString();
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
    }

    @Test
    public void cacheKeyWithValueObject() {
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)new TestValue(1)).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)new TestValue(1)).traverse(this.newHandler());
        String s2 = this.cacheKey.toString();
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)new TestValue(2)).traverse(this.newHandler());
        String s3 = this.cacheKey.toString();
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
    }

    @Test
    public void cacheKeyWithPersistentObject() {
        Persistent persistent1 = (Persistent)Mockito.mock(Persistent.class);
        ObjectId objectId1 = (ObjectId)Mockito.mock(ObjectId.class);
        Mockito.when((Object)objectId1.toString()).thenReturn((Object)"objId1");
        Mockito.when((Object)persistent1.getObjectId()).thenReturn((Object)objectId1);
        Persistent persistent2 = (Persistent)Mockito.mock(Persistent.class);
        ObjectId objectId2 = (ObjectId)Mockito.mock(ObjectId.class);
        Mockito.when((Object)objectId2.toString()).thenReturn((Object)"objId2");
        Mockito.when((Object)persistent2.getObjectId()).thenReturn((Object)objectId2);
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)persistent1).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)persistent1).traverse(this.newHandler());
        String s2 = this.cacheKey.toString();
        ExpressionFactory.greaterOrEqualExp("testPath", (Object)persistent2).traverse(this.newHandler());
        String s3 = this.cacheKey.toString();
        Assert.assertTrue((boolean)s1.contains("objId1"));
        Assert.assertTrue((boolean)s3.contains("objId2"));
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
    }

    @Test
    public void cacheKeyWithFunctionCall() {
        ExpressionFactory.exp("length(testPath)", new Object[0]).traverse(this.newHandler());
        String s1 = this.cacheKey.toString();
        ExpressionFactory.exp("length(testPath)", new Object[0]).traverse(this.newHandler());
        String s2 = this.cacheKey.toString();
        ExpressionFactory.exp("count(testPath)", new Object[0]).traverse(this.newHandler());
        String s3 = this.cacheKey.toString();
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
        ExpressionFactory.exp("substring(path, testPath)", new Object[0]).traverse(this.newHandler());
        String s4 = this.cacheKey.toString();
        ExpressionFactory.exp("substring(path2, testPath)", new Object[0]).traverse(this.newHandler());
        String s5 = this.cacheKey.toString();
        Assert.assertNotEquals((Object)s4, (Object)s5);
        ExpressionFactory.exp("year(path)", new Object[0]).traverse(this.newHandler());
        String s6 = this.cacheKey.toString();
        ExpressionFactory.exp("hour(path)", new Object[0]).traverse(this.newHandler());
        String s7 = this.cacheKey.toString();
        Assert.assertNotEquals((Object)s6, (Object)s7);
    }

    @Test
    public void testPrefetchEmpty() {
        PrefetchTreeNode prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        Assert.assertTrue((boolean)this.cacheKey.toString().isEmpty());
    }

    @Test
    public void testPrefetchSingle() {
        PrefetchTreeNode prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s1 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s2 = this.cacheKey.toString();
        Assert.assertFalse((boolean)s1.isEmpty());
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testPrefetchSemantics() {
        PrefetchTreeNode prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s1 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.disjoint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s2 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.disjointById());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s3 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.disjoint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s4 = this.cacheKey.toString();
        Assert.assertNotEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
        Assert.assertEquals((Object)s2, (Object)s4);
    }

    @Test
    public void testPrefetchMultiNodes() {
        PrefetchTreeNode prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s1 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.merge(Artist.GROUP_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s2 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.merge(Artist.GROUP_ARRAY.joint());
        prefetchTreeNode.merge(Artist.ARTIST_EXHIBIT_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s3 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.merge(Artist.GROUP_ARRAY.joint());
        prefetchTreeNode.merge(Artist.ARTIST_EXHIBIT_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s4 = this.cacheKey.toString();
        Assert.assertNotEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
        Assert.assertEquals((Object)s3, (Object)s4);
    }

    @Test
    public void testPrefetchLongPaths() {
        PrefetchTreeNode prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s1 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.dot(Painting.TO_ARTIST).joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s2 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.dot(Painting.TO_ARTIST).dot(Artist.GROUP_ARRAY).joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s3 = this.cacheKey.toString();
        prefetchTreeNode = new PrefetchTreeNode();
        prefetchTreeNode.merge(Artist.PAINTING_ARRAY.dot(Painting.TO_ARTIST).dot(Artist.GROUP_ARRAY).joint());
        prefetchTreeNode.traverse(this.newPrefetchProcessor());
        String s4 = this.cacheKey.toString();
        Assert.assertNotEquals((Object)s1, (Object)s2);
        Assert.assertNotEquals((Object)s2, (Object)s3);
        Assert.assertEquals((Object)s3, (Object)s4);
    }

    private TraversalHandler newHandler() {
        this.cacheKey = new StringBuilder();
        return new SelectQueryMetadata.ToCacheKeyTraversalHandler(this.registry, this.cacheKey);
    }

    private PrefetchProcessor newPrefetchProcessor() {
        this.cacheKey = new StringBuilder();
        return new SelectQueryMetadata.ToCacheKeyPrefetchProcessor(this.cacheKey);
    }

    static class TestValueType
    implements ValueObjectType<TestValue, Integer> {
        TestValueType() {
        }

        @Override
        public Class<Integer> getTargetType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<TestValue> getValueType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TestValue toJavaObject(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer fromJavaObject(TestValue object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toCacheKey(TestValue object) {
            return Integer.toString(object.v);
        }
    }

    static class TestValue {
        int v = 0;

        TestValue(int v) {
            this.v = v;
        }
    }

    static enum TestEnum {
        VALUE_1,
        VALUE_2;

    }
}

