/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.AbstractMappedQuery;
import org.apache.cayenne.query.MappedExec;
import org.apache.cayenne.query.MappedSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.ExternalTransaction;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class MappedQueryIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private JdbcEventLogger jdbcEventLogger;

    protected void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        for (int i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
    }

    @Test
    public void testSelectQuery() throws Exception {
        this.createArtistsDataSet();
        Artist a = (Artist)((MappedSelect)MappedSelect.query("ParameterizedQueryWithLocalCache", Artist.class).param("name", "artist14")).select(this.context).get(0);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist14", (Object)a.getArtistName());
    }

    @Test
    public void testSQLTemplateSelect() throws Exception {
        this.createArtistsDataSet();
        List<DataRow> result = MappedSelect.query("SelectTestLower", DataRow.class).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertThat((Object)result.get(0), (Matcher)CoreMatchers.instanceOf(DataRow.class));
    }

    @Test
    public void testSQLTemplateUpdate() throws Exception {
        int updated = MappedExec.query("NonSelectingQuery").update(this.context)[0];
        Assert.assertEquals((long)1L, (long)updated);
        Painting painting = (Painting)ObjectSelect.query(Painting.class).selectOne(this.context);
        Assert.assertEquals((Object)"No Painting Like This", (Object)painting.getPaintingTitle());
        Assert.assertEquals((double)12.5, (double)painting.getEstimatedPrice().doubleValue(), (double)0.0);
    }

    @Test
    public void testProcedureQuery() throws Exception {
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        if (!this.accessStackAdapter.canMakeObjectsOutOfProcedures()) {
            return;
        }
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("An Artist");
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("A Painting");
        p.setEstimatedPrice(new BigDecimal(1000));
        a.addToPaintingArray(p);
        this.context.commitChanges();
        List artists = this.runProcedureSelect(((MappedSelect)((MappedSelect)MappedSelect.query("ProcedureQuery", Artist.class).param("aName", "An Artist")).param("paintingPrice", 3000)).forceNoCache()).firstList();
        Assert.assertNotNull((String)"Null result from StoredProcedure.", (Object)artists);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist artistRow = (Artist)artists.get(0);
        Assert.assertEquals((Object)"An Artist", (Object)artistRow.getArtistName());
    }

    @Test
    public void testEJBQLQuery() throws Exception {
        this.createArtistsDataSet();
        List<?> result = MappedSelect.query("EjbqlQueryTest").select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertThat(result.get(0), (Matcher)CoreMatchers.instanceOf(DataRow.class));
    }

    @Test
    public void testCacheKey() {
        AbstractMappedQuery query1 = MappedSelect.query("ParameterizedQueryWithLocalCache", Artist.class).param("name", "artist1");
        AbstractMappedQuery query2 = MappedSelect.query("ParameterizedQueryWithLocalCache", Artist.class).param("name", "artist2");
        AbstractMappedQuery query3 = MappedSelect.query("ParameterizedQueryWithLocalCache", Artist.class).param("name", "artist2");
        Assert.assertNotEquals((Object)query1.getMetaData(this.context.getEntityResolver()).getCacheKey(), (Object)query2.getMetaData(this.context.getEntityResolver()).getCacheKey());
        Assert.assertEquals((Object)query2.getMetaData(this.context.getEntityResolver()).getCacheKey(), (Object)query3.getMetaData(this.context.getEntityResolver()).getCacheKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResponse runProcedureSelect(AbstractMappedQuery q) throws Exception {
        ExternalTransaction t = new ExternalTransaction(this.jdbcEventLogger);
        BaseTransaction.bindThreadTransaction(t);
        try {
            QueryResponse queryResponse = this.context.performGenericQuery(q);
            return queryResponse;
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            t.commit();
        }
    }
}

