/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ASTEqualIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testEvaluate_DataObject() {
        Artist a1 = this.context.newObject(Artist.class);
        Artist a2 = this.context.newObject(Artist.class);
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        Painting p3 = this.context.newObject(Painting.class);
        a1.setArtistName("a1");
        a2.setArtistName("a2");
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        p3.setPaintingTitle("p3");
        this.context.commitChanges();
        p1.setToArtist(a1);
        p2.setToArtist(a2);
        ASTEqual e = new ASTEqual(new ASTObjPath("toArtist"), a1);
        Assert.assertTrue((boolean)e.match(p1));
        Assert.assertFalse((boolean)e.match(p2));
        Assert.assertFalse((boolean)e.match(p3));
    }

    @Test
    public void testEvaluate_TempId() {
        Artist a1 = this.context.newObject(Artist.class);
        Artist a2 = this.context.newObject(Artist.class);
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        Painting p3 = this.context.newObject(Painting.class);
        p1.setToArtist(a1);
        p2.setToArtist(a2);
        ASTEqual e = new ASTEqual(new ASTObjPath("toArtist"), a1.getObjectId());
        Assert.assertTrue((boolean)e.match(p1));
        Assert.assertFalse((boolean)e.match(p2));
        Assert.assertFalse((boolean)e.match(p3));
    }

    @Test
    public void testEvaluate_Id() throws Exception {
        Artist a1 = this.context.newObject(Artist.class);
        Artist a2 = this.context.newObject(Artist.class);
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        Painting p3 = this.context.newObject(Painting.class);
        a1.setArtistName("a1");
        a2.setArtistName("a2");
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        p3.setPaintingTitle("p3");
        p1.setToArtist(a1);
        p2.setToArtist(a2);
        this.context.commitChanges();
        ASTEqual e = new ASTEqual(new ASTObjPath("toArtist"), Cayenne.longPKForObject(a1));
        Assert.assertTrue((boolean)e.match(p1));
        Assert.assertFalse((boolean)e.match(p2));
        Assert.assertFalse((boolean)e.match(p3));
    }
}

