/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.EventListener;
import java.util.EventObject;
import org.apache.cayenne.event.CayenneEvent;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.event.MockListener;
import org.apache.cayenne.event.MyCayenneEvent;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultEventManagerTest
implements EventListener {
    public static int numberOfReceivedEventsForClass;
    public int numberOfReceivedEvents;
    private EventManager eventManager;

    @Before
    public void setUp() {
        this.eventManager = new DefaultEventManager();
        this.numberOfReceivedEvents = 0;
        numberOfReceivedEventsForClass = 0;
    }

    @After
    public void tearDown() {
        ((DefaultEventManager)this.eventManager).shutdown();
    }

    @Test
    public void testSubjectListenerWouldRegisterListener() {
        MockListener listener = new MockListener(this.eventManager);
        this.eventManager.addListener(listener, "processEvent", EventObject.class, MockListener.mockSubject);
        this.eventManager.addListener(new MockListener(this.eventManager), "processEvent", EventObject.class, MockListener.mockSubject);
        this.eventManager.postEvent(new EventObject(this), MockListener.mockSubject);
    }

    @Test
    public void testObjectListenerWouldRegisterListener() {
        MockListener listener = new MockListener(this.eventManager, this);
        this.eventManager.addListener(listener, "processEvent", EventObject.class, MockListener.mockSubject, this);
        this.eventManager.addListener(new MockListener(this.eventManager, this), "processEvent", EventObject.class, MockListener.mockSubject, this);
        this.eventManager.postEvent(new EventObject(this), MockListener.mockSubject);
    }

    @Test
    public void testNullListener() {
        try {
            EventSubject subject = EventSubject.getSubject(this.getClass(), "hansi");
            this.eventManager.addListener(null, null, null, subject);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullNotification() {
        EventSubject subject2;
        try {
            this.eventManager.addListener(this, "testNullObserver", CayenneEvent.class, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            subject2 = EventSubject.getSubject(this.getClass(), "");
            this.eventManager.addListener(this, "testNullObserver", null, subject2);
            Assert.fail();
        }
        catch (IllegalArgumentException subject2) {
            // empty catch block
        }
        try {
            subject2 = EventSubject.getSubject(this.getClass(), "");
            this.eventManager.addListener(this, "testNullObserver", CayenneEvent.class, subject2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNonexistingMethod() {
        try {
            EventSubject subject = EventSubject.getSubject(this.getClass(), "hansi");
            this.eventManager.addListener(this, "thisMethodDoesNotExist", CayenneEvent.class, subject);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidArgumentTypes() {
        try {
            EventSubject subject = EventSubject.getSubject(this.getClass(), "hansi");
            this.eventManager.addListener(this, "seeTheWrongMethod", CayenneEvent.class, subject);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testNonretainedListener() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(new DefaultEventManagerTest(), "seeNotification", CayenneEvent.class, subject);
        System.gc();
        System.gc();
        this.eventManager.postEvent(new CayenneEvent(this), subject);
        Assert.assertEquals((long)0L, (long)numberOfReceivedEventsForClass);
    }

    @Test
    public void testValidSubclassOfRegisteredEventClass() throws Exception {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject);
        this.eventManager.postEvent(new MyCayenneEvent(this), subject);
        DefaultEventManagerTest.assertReceivedEvents(1, this);
    }

    @Test
    public void testWrongRegisteredEventClass() throws Exception {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject);
        this.eventManager.postEvent(new EventObject(this), subject);
        DefaultEventManagerTest.assertReceivedEvents(0, this);
    }

    @Test
    public void testSuccessfulNotificationDefaultSender() throws Exception {
        DefaultEventManagerTest listener1 = this;
        DefaultEventManagerTest listener2 = new DefaultEventManagerTest();
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(listener1, "seeNotification", CayenneEvent.class, subject);
        this.eventManager.addListener(listener2, "seeNotification", CayenneEvent.class, subject);
        this.eventManager.postEvent(new CayenneEvent(this), subject);
        DefaultEventManagerTest.assertReceivedEvents(1, listener1);
        DefaultEventManagerTest.assertReceivedEvents(1, listener2);
        DefaultEventManagerTest.assertReceivedEventsForClass(2);
    }

    @Test
    public void testSuccessfulNotificationIndividualSender() throws Exception {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject, this);
        this.eventManager.postEvent(new CayenneEvent(this), subject);
        DefaultEventManagerTest.assertReceivedEvents(1, this);
        DefaultEventManagerTest.assertReceivedEventsForClass(1);
    }

    @Test
    public void testSuccessfulNotificationIndividualSenderTwice() throws Exception {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject);
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject, this);
        this.eventManager.postEvent(new CayenneEvent(this), subject);
        DefaultEventManagerTest.assertReceivedEvents(2, this);
        DefaultEventManagerTest.assertReceivedEventsForClass(2);
    }

    @Test
    public void testSuccessfulNotificationBothDefaultAndIndividualSender() throws Exception {
        DefaultEventManagerTest listener1 = this;
        DefaultEventManagerTest listener2 = new DefaultEventManagerTest();
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(listener1, "seeNotification", CayenneEvent.class, subject, listener1);
        this.eventManager.addListener(listener2, "seeNotification", CayenneEvent.class, subject);
        this.eventManager.postEvent(new CayenneEvent(this), subject);
        DefaultEventManagerTest.assertReceivedEvents(1, listener1);
        DefaultEventManagerTest.assertReceivedEvents(1, listener2);
        DefaultEventManagerTest.assertReceivedEventsForClass(2);
    }

    @Test
    public void testRemoveOnEmptyList() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        Assert.assertFalse((boolean)this.eventManager.removeListener(this, subject));
    }

    @Test
    public void testRemoveOnNullSubject() {
        Assert.assertFalse((boolean)this.eventManager.removeListener(this, null));
    }

    @Test
    public void testRemoveFromDefaultQueue() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject);
        Assert.assertTrue((boolean)this.eventManager.removeListener(this, subject));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this));
    }

    @Test
    public void testRemoveSpecificQueue() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject, this);
        Assert.assertTrue((boolean)this.eventManager.removeListener(this, subject));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this));
    }

    @Test
    public void testRemoveSpecificSender() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject, this);
        Assert.assertTrue((boolean)this.eventManager.removeListener(this, subject, this));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this));
    }

    @Test
    public void testRemoveNullSender() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject, this);
        Assert.assertTrue((boolean)this.eventManager.removeListener(this, subject, null));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this));
    }

    @Test
    public void testRemoveNonexistingSender() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject, this);
        Assert.assertFalse((boolean)this.eventManager.removeListener(this, subject, "foo"));
        Assert.assertTrue((boolean)this.eventManager.removeListener(this));
    }

    @Test
    public void testRemoveAll() {
        EventSubject subject1 = EventSubject.getSubject(this.getClass(), "XXX1");
        EventSubject subject2 = EventSubject.getSubject(this.getClass(), "XXX2");
        EventSubject subject3 = EventSubject.getSubject(this.getClass(), "XXX3");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject1);
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject2);
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject3, this);
        Assert.assertTrue((boolean)this.eventManager.removeListener(this));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this, subject1));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this, subject2));
        Assert.assertFalse((boolean)this.eventManager.removeListener(this, subject3));
    }

    @Test
    public void testSubjectGarbageCollection() {
        EventSubject subject = EventSubject.getSubject(this.getClass(), "XXX");
        this.eventManager.addListener(this, "seeNotification", CayenneEvent.class, subject);
        subject = null;
        System.gc();
        System.gc();
        Assert.assertFalse((boolean)this.eventManager.removeListener(this));
    }

    public void seeNotification(CayenneEvent event) {
        ++this.numberOfReceivedEvents;
        ++numberOfReceivedEventsForClass;
    }

    private static void assertReceivedEvents(final int expected, final DefaultEventManagerTest listener) throws Exception {
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)expected, (long)listener.numberOfReceivedEvents);
            }
        };
        helper.runTest(5000L);
    }

    private static void assertReceivedEventsForClass(final int expected) throws Exception {
        ParallelTestContainer helper = new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)expected, (long)numberOfReceivedEventsForClass);
            }
        };
        helper.runTest(5000L);
    }
}

