/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import org.apache.cayenne.dba.postgres.PostgresAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PostgresAdapterIT
extends ServerCase {
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testCreateTableWithFloatAttributeWithScale() {
        PostgresAdapter adapter = (PostgresAdapter)this.objectFactory.newInstance(PostgresAdapter.class, PostgresAdapter.class.getName());
        DbEntity e = new DbEntity("Test");
        DbAttribute dblPrec = new DbAttribute("dbl1");
        dblPrec.setType(6);
        dblPrec.setMaxLength(22);
        dblPrec.setScale(12);
        e.addAttribute(dblPrec);
        String sql = adapter.createTable(e);
        Assert.assertTrue((sql.indexOf("float(22)") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)sql.indexOf("float(22, 12)"));
        Assert.assertEquals((Object)"CREATE TABLE Test (dbl1 float(22) NULL)", (Object)sql);
    }
}

