/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OraclePkGenerator;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class OraclePkGeneratorIT
extends ServerCase {
    @Inject
    protected JdbcEventLogger logger;
    @Inject
    protected AdhocObjectFactory objectFactory;
    private OraclePkGenerator pkGenerator;

    @Before
    public void setUp() throws Exception {
        OracleAdapter adapter = (OracleAdapter)this.objectFactory.newInstance(OracleAdapter.class, OracleAdapter.class.getName());
        this.pkGenerator = new OraclePkGenerator(adapter);
    }

    @Test
    public void testSequenceNameDefault() throws Exception {
        DbEntity entity = new DbEntity("TEST_ENTITY");
        Assert.assertEquals((Object)"pk_test_entity", (Object)this.pkGenerator.sequenceName(entity));
    }

    @Test
    public void testSequenceNameCustom1() throws Exception {
        DbEntity entity = new DbEntity("TEST_ENTITY");
        DbKeyGenerator customGenerator = new DbKeyGenerator();
        customGenerator.setGeneratorType("ORACLE");
        customGenerator.setGeneratorName("CUSTOM_GENERATOR");
        entity.setPrimaryKeyGenerator(customGenerator);
        Assert.assertEquals((Object)"custom_generator", (Object)this.pkGenerator.sequenceName(entity));
    }

    @Test
    public void testSequenceNameCustom2() throws Exception {
        DbEntity entity = new DbEntity("TEST_ENTITY");
        DbKeyGenerator customGenerator = new DbKeyGenerator();
        customGenerator.setGeneratorType("NAMED_SEQUENCE_TABLE");
        customGenerator.setGeneratorName("CUSTOM_GENERATOR");
        Assert.assertEquals((Object)"pk_test_entity", (Object)this.pkGenerator.sequenceName(entity));
    }
}

