/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cayenne.datasource.BasePoolingDataSourceIT;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PoolingDataSourceIT
extends BasePoolingDataSourceIT {
    @Test(expected=UnsupportedOperationException.class)
    public void testGetConnectionWithUserName() throws Exception {
        this.dataSource.getConnection("user", "password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetConnection_AutoCommit() throws Exception {
        Assert.assertTrue((this.dataSource.getMaxConnections() > 0 ? 1 : 0) != 0);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        try {
            Connection c2;
            for (int i = 0; i < this.dataSource.getMaxConnections(); ++i) {
                c2 = this.dataSource.getConnection();
                Assert.assertTrue((String)"Failed to reset connection state", (boolean)c2.getAutoCommit());
                connections.add(c2);
            }
            for (Connection c2 : connections) {
                c2.setAutoCommit(false);
                c2.close();
            }
            for (int i = 0; i < this.dataSource.getMaxConnections(); ++i) {
                c2 = this.dataSource.getConnection();
                Assert.assertTrue((boolean)connections.contains(c2));
                Assert.assertTrue((String)"Failed to reset connection state for reused connection", (boolean)c2.getAutoCommit());
            }
        }
        finally {
            for (Connection c2 : connections) {
                try {
                    c2.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetConnection_FailOnFull() throws Exception {
        Assert.assertTrue((this.dataSource.getMaxConnections() > 0 ? 1 : 0) != 0);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        try {
            for (int i = 0; i < this.dataSource.getMaxConnections(); ++i) {
                connections.add(this.dataSource.getConnection());
            }
            long t0 = System.currentTimeMillis();
            try {
                this.dataSource.getConnection();
                Assert.fail((String)"Opening more connections than the pool allows succeeded");
            }
            catch (SQLException e) {
                long t1 = System.currentTimeMillis();
                Assert.assertTrue((t1 - t0 >= 1000L ? 1 : 0) != 0);
            }
        }
        finally {
            for (Connection c : connections) {
                try {
                    c.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Test
    public void testGetConnection() throws Exception {
        Assert.assertEquals((long)2L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)2L, (long)this.dataSource.availableSize());
        Connection c1 = this.dataSource.getConnection();
        Assert.assertEquals((long)2L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)1L, (long)this.dataSource.availableSize());
        Connection c2 = this.dataSource.getConnection();
        Assert.assertEquals((long)2L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)0L, (long)this.dataSource.availableSize());
        Connection c3 = this.dataSource.getConnection();
        Assert.assertEquals((long)3L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)0L, (long)this.dataSource.availableSize());
        c1.close();
        Assert.assertEquals((long)3L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)1L, (long)this.dataSource.availableSize());
        c2.close();
        Assert.assertEquals((long)3L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)2L, (long)this.dataSource.availableSize());
        c3.close();
        Assert.assertEquals((long)3L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)3L, (long)this.dataSource.availableSize());
    }

    @Test
    public void testGetConnection_BeforeScopeEnd() throws Exception {
        Assert.assertEquals((long)2L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)2L, (long)this.dataSource.availableSize());
        this.dataSource.close();
        Assert.assertEquals((long)0L, (long)this.dataSource.poolSize());
        Assert.assertEquals((long)0L, (long)this.dataSource.availableSize());
    }

    @Test
    public void testGetConnection_Concurrent() {
        PoolTask[] tasks = new PoolTask[2];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = new PoolTask();
        }
        ExecutorService executor = Executors.newFixedThreadPool(tasks.length);
        for (int j = 0; j < 100; ++j) {
            PoolTask[] poolTaskArray = tasks;
            int n = poolTaskArray.length;
            for (int i = 0; i < n; ++i) {
                PoolTask task = poolTaskArray[i];
                executor.submit(task);
            }
        }
        executor.shutdown();
        try {
            boolean didFinish = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!didFinish) {
                Assert.fail((String)"Connection pool either deadlocked or contended over the lock too long.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (PoolTask task : tasks) {
            Assert.assertEquals((long)100L, (long)task.i.get());
        }
    }

    class PoolTask
    implements Runnable {
        AtomicInteger i = new AtomicInteger();

        PoolTask() {
        }

        @Override
        public void run() {
            try {
                try (Connection c = PoolingDataSourceIT.this.dataSource.getConnection();
                     Statement st = c.createStatement();
                     ResultSet rs = st.executeQuery("SELECT ARTIST_ID FROM ARTIST");){
                    rs.next();
                }
                this.i.incrementAndGet();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

